/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.crypto.tls.Certificate;
import cfca.sadk.org.bouncycastle.crypto.tls.CertificateRequest;
import cfca.sadk.org.bouncycastle.crypto.tls.DefaultTlsClient;
import cfca.sadk.org.bouncycastle.crypto.tls.ProtocolVersion;
import cfca.sadk.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsAuthentication;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsCredentials;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsFatalAlert;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestConfig;
import cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestUtils;
import cfca.sadk.org.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Vector;

class TlsTestClientImpl
extends DefaultTlsClient {
    protected final TlsTestConfig config;
    protected int firstFatalAlertConnectionEnd = -1;
    protected short firstFatalAlertDescription = (short)-1;

    TlsTestClientImpl(TlsTestConfig config) {
        this.config = config;
    }

    int getFirstFatalAlertConnectionEnd() {
        return this.firstFatalAlertConnectionEnd;
    }

    short getFirstFatalAlertDescription() {
        return this.firstFatalAlertDescription;
    }

    public ProtocolVersion getClientVersion() {
        if (this.config.clientOfferVersion != null) {
            return this.config.clientOfferVersion;
        }
        return super.getClientVersion();
    }

    public ProtocolVersion getMinimumVersion() {
        if (this.config.clientMinimumVersion != null) {
            return this.config.clientMinimumVersion;
        }
        return super.getMinimumVersion();
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Exception cause) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 1;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 0;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        super.notifyServerVersion(serverVersion);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            public void notifyServerCertificate(Certificate serverCertificate) throws IOException {
                boolean isEmpty = serverCertificate == null || serverCertificate.isEmpty();
                cfca.sadk.org.bouncycastle.asn1.x509.Certificate[] chain = serverCertificate.getCertificateList();
                if (isEmpty || !chain[0].equals(TlsTestUtils.loadCertificateResource("x509-server.pem"))) {
                    throw new TlsFatalAlert(42);
                }
            }

            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                if (TlsTestClientImpl.this.config.serverCertReq == 0) {
                    throw new IllegalStateException();
                }
                if (TlsTestClientImpl.this.config.clientAuth == 0) {
                    return null;
                }
                short[] certificateTypes = certificateRequest.getCertificateTypes();
                if (certificateTypes == null || !Arrays.contains(certificateTypes, (short)1)) {
                    return null;
                }
                SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
                Vector sigAlgs = certificateRequest.getSupportedSignatureAlgorithms();
                if (sigAlgs != null) {
                    for (int i = 0; i < sigAlgs.size(); ++i) {
                        SignatureAndHashAlgorithm sigAlg = (SignatureAndHashAlgorithm)sigAlgs.elementAt(i);
                        if (sigAlg.getSignature() != 1) continue;
                        signatureAndHashAlgorithm = sigAlg;
                        break;
                    }
                    if (signatureAndHashAlgorithm == null) {
                        return null;
                    }
                }
                final TlsSignerCredentials signerCredentials = TlsTestUtils.loadSignerCredentials(TlsTestClientImpl.this.context, new String[]{"x509-client.pem", "x509-ca.pem"}, "x509-client-key.pem", signatureAndHashAlgorithm);
                if (TlsTestClientImpl.this.config.clientAuth == 1) {
                    return signerCredentials;
                }
                return new TlsSignerCredentials(){

                    public byte[] generateCertificateSignature(byte[] hash) throws IOException {
                        byte[] sig = signerCredentials.generateCertificateSignature(hash);
                        if ((this).TlsTestClientImpl.this.config.clientAuth == 3) {
                            sig = TlsTestClientImpl.this.corruptBit(sig);
                        }
                        return sig;
                    }

                    public Certificate getCertificate() {
                        Certificate cert = signerCredentials.getCertificate();
                        if ((this).TlsTestClientImpl.this.config.clientAuth == 2) {
                            cert = TlsTestClientImpl.this.corruptCertificate(cert);
                        }
                        return cert;
                    }

                    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
                        return signerCredentials.getSignatureAndHashAlgorithm();
                    }
                };
            }
        };
    }

    protected Certificate corruptCertificate(Certificate cert) {
        cfca.sadk.org.bouncycastle.asn1.x509.Certificate[] certList = cert.getCertificateList();
        certList[0] = this.corruptCertificateSignature(certList[0]);
        return new Certificate(certList);
    }

    protected cfca.sadk.org.bouncycastle.asn1.x509.Certificate corruptCertificateSignature(cfca.sadk.org.bouncycastle.asn1.x509.Certificate cert) {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(cert.getTBSCertificate());
        v.add(cert.getSignatureAlgorithm());
        v.add(this.corruptBitString(cert.getSignature()));
        return cfca.sadk.org.bouncycastle.asn1.x509.Certificate.getInstance(new DERSequence(v));
    }

    protected DERBitString corruptBitString(DERBitString bs) {
        return new DERBitString(this.corruptBit(bs.getBytes()));
    }

    protected byte[] corruptBit(byte[] bs) {
        bs = Arrays.clone(bs);
        int bit = this.context.getSecureRandom().nextInt(bs.length << 3);
        int n = bit >>> 3;
        bs[n] = (byte)(bs[n] ^ 1 << (bit & 7));
        return bs;
    }
}

