/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls.test;

import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.crypto.tls.Certificate;
import cfca.sadk.org.bouncycastle.crypto.tls.CertificateRequest;
import cfca.sadk.org.bouncycastle.crypto.tls.DefaultTlsServer;
import cfca.sadk.org.bouncycastle.crypto.tls.ProtocolVersion;
import cfca.sadk.org.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsFatalAlert;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsSignerCredentials;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;
import cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestConfig;
import cfca.sadk.org.bouncycastle.crypto.tls.test.TlsTestUtils;
import java.io.IOException;
import java.util.Vector;

class TlsTestServerImpl
extends DefaultTlsServer {
    protected final TlsTestConfig config;
    protected int firstFatalAlertConnectionEnd = -1;
    protected short firstFatalAlertDescription = (short)-1;

    TlsTestServerImpl(TlsTestConfig config) {
        this.config = config;
    }

    int getFirstFatalAlertConnectionEnd() {
        return this.firstFatalAlertConnectionEnd;
    }

    short getFirstFatalAlertDescription() {
        return this.firstFatalAlertDescription;
    }

    protected ProtocolVersion getMaximumVersion() {
        if (this.config.serverMaximumVersion != null) {
            return this.config.serverMaximumVersion;
        }
        return super.getMaximumVersion();
    }

    protected ProtocolVersion getMinimumVersion() {
        if (this.config.serverMinimumVersion != null) {
            return this.config.serverMinimumVersion;
        }
        return super.getMinimumVersion();
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Exception cause) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 0;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 1;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        return serverVersion;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        if (this.config.serverCertReq == 0) {
            return null;
        }
        Vector<SignatureAndHashAlgorithm> serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.serverVersion)) {
            short[] hashAlgorithms = new short[]{6, 5, 4, 3, 2};
            short[] signatureAlgorithms = new short[]{1};
            serverSigAlgs = new Vector<SignatureAndHashAlgorithm>();
            for (int i = 0; i < hashAlgorithms.length; ++i) {
                for (int j = 0; j < signatureAlgorithms.length; ++j) {
                    serverSigAlgs.addElement(new SignatureAndHashAlgorithm(hashAlgorithms[i], signatureAlgorithms[j]));
                }
            }
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        certificateAuthorities.add(TlsTestUtils.loadCertificateResource("x509-ca.pem").getSubject());
        return new CertificateRequest(new short[]{1}, serverSigAlgs, certificateAuthorities);
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        boolean isEmpty = clientCertificate == null || clientCertificate.isEmpty();
        if (isEmpty != (this.config.clientAuth == 0)) {
            throw new IllegalStateException();
        }
        if (isEmpty && this.config.serverCertReq == 2) {
            throw new TlsFatalAlert(40);
        }
        cfca.sadk.org.bouncycastle.asn1.x509.Certificate[] chain = clientCertificate.getCertificateList();
        if (!isEmpty && !chain[0].equals(TlsTestUtils.loadCertificateResource("x509-client.pem"))) {
            throw new TlsFatalAlert(42);
        }
    }

    protected TlsEncryptionCredentials getRSAEncryptionCredentials() throws IOException {
        return TlsTestUtils.loadEncryptionCredentials(this.context, new String[]{"x509-server.pem", "x509-ca.pem"}, "x509-server-key.pem");
    }

    protected TlsSignerCredentials getRSASignerCredentials() throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        Vector sigAlgs = this.supportedSignatureAlgorithms;
        if (sigAlgs != null) {
            for (int i = 0; i < sigAlgs.size(); ++i) {
                SignatureAndHashAlgorithm sigAlg = (SignatureAndHashAlgorithm)sigAlgs.elementAt(i);
                if (sigAlg.getSignature() != 1) continue;
                signatureAndHashAlgorithm = sigAlg;
                break;
            }
            if (signatureAndHashAlgorithm == null) {
                return null;
            }
        }
        return TlsTestUtils.loadSignerCredentials(this.context, new String[]{"x509-server.pem", "x509-ca.pem"}, "x509-server-key.pem", signatureAndHashAlgorithm);
    }
}

