/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.dvcs.test;

import cfca.sadk.org.bouncycastle.asn1.dvcs.CertEtcToken;
import cfca.sadk.org.bouncycastle.asn1.dvcs.TargetEtcChain;
import cfca.sadk.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import cfca.sadk.org.bouncycastle.cms.CMSSignedData;
import cfca.sadk.org.bouncycastle.cms.CMSSignedDataGenerator;
import cfca.sadk.org.bouncycastle.cms.SignerId;
import cfca.sadk.org.bouncycastle.cms.SignerInformationVerifier;
import cfca.sadk.org.bouncycastle.cms.SignerInformationVerifierProvider;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import cfca.sadk.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import cfca.sadk.org.bouncycastle.cms.test.CMSTestUtil;
import cfca.sadk.org.bouncycastle.dvcs.CCPDRequestBuilder;
import cfca.sadk.org.bouncycastle.dvcs.CCPDRequestData;
import cfca.sadk.org.bouncycastle.dvcs.CPDRequestBuilder;
import cfca.sadk.org.bouncycastle.dvcs.CPDRequestData;
import cfca.sadk.org.bouncycastle.dvcs.DVCSException;
import cfca.sadk.org.bouncycastle.dvcs.DVCSRequest;
import cfca.sadk.org.bouncycastle.dvcs.MessageImprint;
import cfca.sadk.org.bouncycastle.dvcs.MessageImprintBuilder;
import cfca.sadk.org.bouncycastle.dvcs.SignedDVCSMessageGenerator;
import cfca.sadk.org.bouncycastle.dvcs.TargetChain;
import cfca.sadk.org.bouncycastle.dvcs.VPKCRequestBuilder;
import cfca.sadk.org.bouncycastle.dvcs.VPKCRequestData;
import cfca.sadk.org.bouncycastle.dvcs.VSDRequestBuilder;
import cfca.sadk.org.bouncycastle.dvcs.VSDRequestData;
import cfca.sadk.org.bouncycastle.dvcs.test.DVCSParseTest;
import cfca.sadk.org.bouncycastle.dvcs.test.DVCSTestSetup;
import cfca.sadk.org.bouncycastle.dvcs.test.SHA1DigestCalculator;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.operator.ContentSigner;
import cfca.sadk.org.bouncycastle.operator.OperatorCreationException;
import cfca.sadk.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import cfca.sadk.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import cfca.sadk.org.bouncycastle.util.Arrays;
import cfca.sadk.org.bouncycastle.util.io.Streams;
import java.io.IOException;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AllTests
extends TestCase {
    private static final String BC = "BC";
    private static boolean initialised = false;
    private static String origDN;
    private static KeyPair origKP;
    private static X509Certificate origCert;
    private static String signDN;
    private static KeyPair signKP;
    private static X509Certificate signCert;

    private static void init() throws Exception {
        if (!initialised) {
            initialised = true;
            if (Security.getProvider(BC) == null) {
                Security.addProvider(new BouncyCastleProvider());
            }
            origDN = "O=Bouncy Castle, C=AU";
            origKP = CMSTestUtil.makeKeyPair();
            origCert = CMSTestUtil.makeCertificate(origKP, origDN, origKP, origDN);
            signDN = "CN=Bob, OU=Sales, O=Bouncy Castle, C=AU";
            signKP = CMSTestUtil.makeKeyPair();
            signCert = CMSTestUtil.makeCertificate(signKP, signDN, origKP, origDN);
        }
    }

    public void setUp() throws Exception {
        AllTests.init();
    }

    private byte[] getInput(String name) throws IOException {
        return Streams.readAll(((Object)((Object)this)).getClass().getResourceAsStream(name));
    }

    public void testCCPDRequest() throws Exception {
        SignedDVCSMessageGenerator gen = this.getSignedDVCSMessageGenerator();
        CCPDRequestBuilder reqBuilder = new CCPDRequestBuilder();
        MessageImprintBuilder imprintBuilder = new MessageImprintBuilder(new SHA1DigestCalculator());
        MessageImprint messageImprint = imprintBuilder.build(new byte[100]);
        CMSSignedData reqMsg = gen.build(reqBuilder.build(messageImprint));
        AllTests.assertTrue((boolean)reqMsg.verifySignatures(new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider(AllTests.BC).build(signCert);
            }
        }));
        DVCSRequest request = new DVCSRequest(reqMsg);
        CCPDRequestData reqData = (CCPDRequestData)request.getData();
        AllTests.assertEquals((Object)messageImprint, (Object)reqData.getMessageImprint());
    }

    private CMSSignedData getWrappedCPDRequest() throws OperatorCreationException, CertificateEncodingException, DVCSException, IOException {
        SignedDVCSMessageGenerator gen = this.getSignedDVCSMessageGenerator();
        CPDRequestBuilder reqBuilder = new CPDRequestBuilder();
        return gen.build(reqBuilder.build(new byte[100]));
    }

    public void testCPDRequest() throws Exception {
        CMSSignedData reqMsg = this.getWrappedCPDRequest();
        AllTests.assertTrue((boolean)reqMsg.verifySignatures(new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider(AllTests.BC).build(signCert);
            }
        }));
        DVCSRequest request = new DVCSRequest(reqMsg);
        CPDRequestData reqData = (CPDRequestData)request.getData();
        AllTests.assertTrue((boolean)Arrays.areEqual(new byte[100], reqData.getMessage()));
    }

    public void testVPKCRequest() throws Exception {
        SignedDVCSMessageGenerator gen = this.getSignedDVCSMessageGenerator();
        VPKCRequestBuilder reqBuilder = new VPKCRequestBuilder();
        reqBuilder.addTargetChain(new JcaX509CertificateHolder(signCert));
        CMSSignedData reqMsg = gen.build(reqBuilder.build());
        AllTests.assertTrue((boolean)reqMsg.verifySignatures(new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider(AllTests.BC).build(signCert);
            }
        }));
        DVCSRequest request = new DVCSRequest(reqMsg);
        VPKCRequestData reqData = (VPKCRequestData)request.getData();
        AllTests.assertEquals((Object)new TargetEtcChain(new CertEtcToken(0, new JcaX509CertificateHolder(signCert).toASN1Structure())), (Object)((TargetChain)reqData.getCerts().get(0)).toASN1Structure());
    }

    public void testVSDRequest() throws Exception {
        CMSSignedData message = this.getWrappedCPDRequest();
        SignedDVCSMessageGenerator gen = this.getSignedDVCSMessageGenerator();
        VSDRequestBuilder reqBuilder = new VSDRequestBuilder();
        CMSSignedData reqMsg = gen.build(reqBuilder.build(message));
        AllTests.assertTrue((boolean)reqMsg.verifySignatures(new SignerInformationVerifierProvider(){

            public SignerInformationVerifier get(SignerId sid) throws OperatorCreationException {
                return new JcaSimpleSignerInfoVerifierBuilder().setProvider(AllTests.BC).build(signCert);
            }
        }));
        DVCSRequest request = new DVCSRequest(reqMsg);
        VSDRequestData reqData = (VSDRequestData)request.getData();
        AllTests.assertEquals((Object)message.toASN1Structure().getContentType(), (Object)reqData.getParsedMessage().toASN1Structure().getContentType());
    }

    private SignedDVCSMessageGenerator getSignedDVCSMessageGenerator() throws OperatorCreationException, CertificateEncodingException {
        CMSSignedDataGenerator sigDataGen = new CMSSignedDataGenerator();
        JcaDigestCalculatorProviderBuilder calculatorProviderBuilder = new JcaDigestCalculatorProviderBuilder().setProvider(BC);
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA1withRSA").setProvider(BC).build(signKP.getPrivate());
        sigDataGen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(calculatorProviderBuilder.build()).build(contentSigner, signCert));
        return new SignedDVCSMessageGenerator(sigDataGen);
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        TestRunner.run((Test)AllTests.suite());
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite("EAC tests");
        suite.addTestSuite(AllTests.class);
        suite.addTestSuite(DVCSParseTest.class);
        return new DVCSTestSetup((Test)suite);
    }
}

