/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jce.provider.test;

import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.security.Key;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class OCBTest
extends SimpleTest {
    public String getName() {
        return "OCB";
    }

    public void performTest() throws Exception {
        this.checkRegistrations();
    }

    private void checkRegistrations() throws Exception {
        String[] ciphers = new String[]{"AES", "NOEKEON", "Twofish", "CAST6", "SEED", "Serpent", "RC6", "CAMELLIA"};
        String[] cipherText = new String[]{"BEA5E8798DBE7110031C144DA0B2612213CC8B747807121A4CBB3E4BD6B456AF", "a2545b927e0f2e6db2998e20b17d5fc0564dcab63b748327e2ef4eaed88cb059", "1cfafe72f7181cae331610c116345e51fc356b379aca04da2a53337c5428d8e4", "5b9b738b2ac7000b33b89dd4eec18dd853f4f7c1d9e17b565405f17a0a8c8b63", "fcdbcee69d02c69858ed4569f78b81920b3027cdb7f1f154634aa5ace9e6ba29", "4f7154cb34558940e85db7d3e96ac6c9cb0d9c1b00b18e82e15d1be83deef9df", "23f3e450c4c7199563a0ed601a5c60d75eb88db2a0d090ae5e84d98438a146aa", "ac13ce9db4af148e910a813fc728e5785e23b1bf1d04a961a3f95f356b9417ab"};
        for (int i = 0; i < ciphers.length; ++i) {
            this.ocbTest(ciphers[i], cipherText[i]);
        }
    }

    private void ocbTest(String cipher, String cText) throws Exception {
        byte[] K = Hex.decode("000102030405060708090A0B0C0D0E0F");
        byte[] P = Hex.decode("000102030405060708090A0B0C0D0E0F");
        byte[] N = Hex.decode("000102030405060708090A0B");
        String T = "4CBB3E4BD6B456AF";
        byte[] C2 = Hex.decode(cText);
        SecretKeySpec key = new SecretKeySpec(K, cipher);
        Cipher in = Cipher.getInstance(cipher + "/OCB/NoPadding", "BC");
        Cipher out = Cipher.getInstance(cipher + "/OCB/NoPadding", "BC");
        in.init(1, (Key)key, new IvParameterSpec(N));
        byte[] enc = in.doFinal(P);
        if (!this.areEqual(enc, C2)) {
            this.fail("ciphertext doesn't match in OCB got " + new String(Hex.encode(enc)));
        }
        out.init(2, (Key)key, new IvParameterSpec(N));
        byte[] dec = out.doFinal(C2);
        if (!this.areEqual(dec, P)) {
            this.fail("plaintext doesn't match in OCB");
        }
        try {
            in = Cipher.getInstance(cipher + "/OCB/PKCS5Padding", "BC");
            this.fail("bad padding missed in OCB");
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        OCBTest.runTest(new OCBTest());
    }
}

