/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jce.provider.test.rsa3;

import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RSA3CertTest
extends TestCase {
    public void setUp() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider(new BouncyCastleProvider());
        }
    }

    public void testA() throws Exception {
        this.doTest("self-testcase-A.pem");
    }

    public void testB() throws Exception {
        this.doTest("self-testcase-B.pem");
    }

    public void testC() throws Exception {
        this.doTest("self-testcase-C.pem");
    }

    public void testD() throws Exception {
        this.doTest("self-testcase-D.pem");
    }

    public void testE() throws Exception {
        this.doTest("self-testcase-E.pem");
    }

    public void testF() throws Exception {
        this.doTest("self-testcase-F.pem");
    }

    public void testG() throws Exception {
        this.doTest("self-testcase-G.pem");
    }

    public void testH() throws Exception {
        this.doTest("self-testcase-H.pem");
    }

    public void testI() throws Exception {
        this.doTest("self-testcase-I.pem");
    }

    public void testJ() throws Exception {
        this.doTest("self-testcase-J.pem");
    }

    public void testL() throws Exception {
        this.doTest("self-testcase-L.pem");
    }

    private void doTest(String certName) throws Exception {
        X509Certificate cert = this.loadCert(certName);
        byte[] tbs = cert.getTBSCertificate();
        Signature sig = Signature.getInstance(cert.getSigAlgName(), "BC");
        sig.initVerify(cert.getPublicKey());
        sig.update(tbs);
        RSA3CertTest.assertFalse((boolean)sig.verify(cert.getSignature()));
    }

    private X509Certificate loadCert(String certName) throws Exception {
        CertificateFactory rd = CertificateFactory.getInstance("X.509", "BC");
        return (X509Certificate)rd.generateCertificate(((Object)((Object)this)).getClass().getResourceAsStream(certName));
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)RSA3CertTest.suite());
    }

    public static Test suite() throws Exception {
        TestSuite suite = new TestSuite("Bleichenbacher's Forgery Attack Tests");
        suite.addTestSuite(RSA3CertTest.class);
        return suite;
    }
}

