/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.mozilla.test;

import cfca.sadk.org.bouncycastle.asn1.ASN1InputStream;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.DERIA5String;
import cfca.sadk.org.bouncycastle.asn1.DEROutputStream;
import cfca.sadk.org.bouncycastle.asn1.mozilla.PublicKeyAndChallenge;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.org.bouncycastle.mozilla.SignedPublicKeyAndChallenge;
import cfca.sadk.org.bouncycastle.util.encoders.Base64;
import cfca.sadk.org.bouncycastle.util.test.SimpleTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.PublicKey;
import java.security.Security;

public class SPKACTest
extends SimpleTest {
    byte[] spkac = Base64.decode("MIIBOjCBpDCBnzANBgkqhkiG9w0BAQEFAAOBjQAwgYkCgYEApne7ti0ibPhV8Iht7Pws5iRckM7x4mtZYxEpeX5/IO8tDsBFdY86ewuY2f2KCca0oMWr43kdkZbPyzf4CSV+0fZm9MJyNMywygZjoOCC+rS8kr0Ef31iHChhYsyejJnjw116Jnn96syhdHY6lVD1rK0nn5ZkHjxU74gjoZu6BJMCAwEAARYAMA0GCSqGSIb3DQEBBAUAA4GBAKFLg/luv0C7gMTI8ZKfFoSyi7Q7kiSQcmSj1WJgT56ouIRJO5NdvB/1n4GNik8VOAU0NRztvGy3ZGqgbSav7lrxcNEvXH+dLbtS97s7yiaozpsOcEHqsBribpLOTRzYa8ciCwkPmIiYqcby11diKLpd+W9RFYNme2v0rrbM2CyV");

    public String getName() {
        return "SignedPubicKeyAndChallenge";
    }

    public void spkacTest(String testName, byte[] req) throws Exception {
        DERIA5String challenge;
        SubjectPublicKeyInfo spki;
        SignedPublicKeyAndChallenge spkac = new SignedPublicKeyAndChallenge(req);
        PublicKeyAndChallenge pkac = spkac.getPublicKeyAndChallenge();
        PublicKey pubKey = spkac.getPublicKey("BC");
        ASN1Primitive obj = pkac.toASN1Primitive();
        if (obj == null) {
            this.fail("Error - " + testName + " PKAC ASN1Primitive was null.");
        }
        if ((obj = spkac.toASN1Primitive()) == null) {
            this.fail("Error - " + testName + " SPKAC ASN1Primitive was null.");
        }
        if ((spki = pkac.getSubjectPublicKeyInfo()) == null) {
            this.fail("Error - " + testName + " SubjectPublicKeyInfo was null.");
        }
        if ((challenge = pkac.getChallenge()) == null) {
            this.fail(":Error - " + testName + " challenge was null.");
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(req);
        ASN1InputStream dIn = new ASN1InputStream(bIn);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        dOut.writeObject(spkac.toASN1Primitive());
        byte[] bytes = bOut.toByteArray();
        if (bytes.length != req.length) {
            this.fail(testName + " failed length test");
        }
        for (int i = 0; i != req.length; ++i) {
            if (bytes[i] == req[i]) continue;
            this.fail(testName + " failed comparison test");
        }
        if (!spkac.verify("BC")) {
            this.fail(testName + " verification failed");
        }
    }

    public void performTest() throws Exception {
        this.spkacTest("spkac", this.spkac);
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        SPKACTest.runTest(new SPKACTest());
    }
}

