/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7SignedData;
import cfca.sadk.algorithm.common.PKCS7SignedFile;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.algorithm.util.FileUtil;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.DERInteger;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.cms.Attribute;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.asn1.cms.CMSAttributes;
import cfca.sadk.org.bouncycastle.asn1.cms.Time;
import cfca.sadk.org.bouncycastle.cms.CMSSignedDataParser;
import cfca.sadk.org.bouncycastle.cms.SignerInformation;
import cfca.sadk.org.bouncycastle.cms.SignerInformationStore;
import cfca.sadk.org.bouncycastle.operator.DigestCalculatorProvider;
import cfca.sadk.org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class Signature {
    private X509Cert signCert = null;
    private String digestAlgorithm = null;
    private byte[] signature = null;
    private byte[] sourceData = null;

    public X509Cert getSignerX509CertFromP7SignData(byte[] p7SignData) throws PKIException {
        PKCS7SignedData pkcs7SignedData = new PKCS7SignedData(null);
        pkcs7SignedData.loadBase64(p7SignData);
        return pkcs7SignedData.getSignerX509Cert();
    }

    public byte[] getContentFromP7SignData(byte[] p7SignData) throws PKIException {
        PKCS7SignedData pkcs7SignedData = new PKCS7SignedData(null);
        pkcs7SignedData.loadBase64(p7SignData);
        return pkcs7SignedData.getSourceData();
    }

    public String getDigestAlgorithmFromP7SignData(byte[] p7SignData) throws PKIException {
        PKCS7SignedData pkcs7SignedData = new PKCS7SignedData(null);
        pkcs7SignedData.loadBase64(p7SignData);
        return pkcs7SignedData.getDigestAlgorithm();
    }

    public byte[] getSourceData() {
        return this.sourceData;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public X509Cert getSignerCert() {
        return this.signCert;
    }

    private byte[] RStoASN1(byte[] signData) throws PKIException {
        if (signData != null && signData.length == 64) {
            byte[] r = null;
            byte[] s = null;
            if ((signData[0] & 0x80) != 0) {
                r = new byte[33];
                r[0] = 0;
                System.arraycopy(signData, 0, r, 1, 32);
            } else {
                r = new byte[32];
                System.arraycopy(signData, 0, r, 0, 32);
            }
            if ((signData[32] & 0x80) != 0) {
                s = new byte[33];
                s[0] = 0;
                System.arraycopy(signData, 32, s, 1, 32);
            } else {
                s = new byte[32];
                System.arraycopy(signData, 32, s, 0, 32);
            }
            DERInteger R = new DERInteger(r);
            DERInteger S = new DERInteger(s);
            ASN1EncodableVector rsV = new ASN1EncodableVector();
            rsV.add(R);
            rsV.add(S);
            DERSequence rsSequence = new DERSequence(rsV);
            try {
                return rsSequence.getEncoded();
            }
            catch (IOException e) {
                throw new PKIException(e.getMessage());
            }
        }
        return signData;
    }

    private byte[] ASN1toRS(byte[] asn1RS) {
        ASN1Sequence sequence = ASN1Sequence.getInstance(asn1RS);
        ASN1Integer R = (ASN1Integer)sequence.getObjectAt(0);
        ASN1Integer S = (ASN1Integer)sequence.getObjectAt(1);
        byte[] r = BigIntegerUtil.asUnsigned32ByteArray(R.getPositiveValue());
        byte[] s = BigIntegerUtil.asUnsigned32ByteArray(S.getPositiveValue());
        byte[] signature = new byte[64];
        System.arraycopy(r, 0, signature, 0, 32);
        System.arraycopy(s, 0, signature, 32, 32);
        return signature;
    }

    public byte[] p1SignByHash(String signAlg, byte[] digest, PrivateKey priKey, Session session) throws PKIException {
        return Base64.encode(this.RStoASN1(session.signByHash(new Mechanism(signAlg), priKey, digest)));
    }

    public byte[] p7SignByHash(String signAlg, byte[] digest, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        X509Cert[] certs = new X509Cert[]{cert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.signByHash(new Mechanism(signAlg), priKey, digest);
        return Base64.encode(p7.packageSignedData(false, null, null, signture, mechanism, certs));
    }

    public boolean p1VerifyByHash(String signAlg, byte[] digest, byte[] signData, PublicKey pubKey, Session session) throws PKIException {
        byte[] asn1RS_RS = null;
        asn1RS_RS = ASN1Parser.isBase64Compatability(signData) ? Base64.decode(signData) : signData;
        if (asn1RS_RS.length == 64 || asn1RS_RS.length >= 128) {
            return session.verifyByHash(new Mechanism(signAlg), pubKey, digest, asn1RS_RS);
        }
        if (asn1RS_RS.length >= 66 && asn1RS_RS.length <= 72) {
            byte[] signature = this.ASN1toRS(asn1RS_RS);
            return session.verifyByHash(new Mechanism(signAlg), pubKey, digest, signature);
        }
        throw new PKIException("the sign data is wrong!");
    }

    public boolean p7VerifyByHash(byte[] digest, byte[] signData, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(signData);
        this.signCert = p7.getSignerX509Cert();
        this.digestAlgorithm = p7.getDigestAlgorithm();
        this.signature = p7.getSignature();
        return p7.verifyP7SignedDataByHash(digest);
    }

    public byte[] p1SignMessage(String signAlg, byte[] sourceData, PrivateKey priKey, Session session) throws PKIException {
        return Base64.encode(this.RStoASN1(session.sign(new Mechanism(signAlg), priKey, sourceData)));
    }

    public byte[] p1SignFile(String signAlg, String sourceFilePath, PrivateKey priKey, Session session) throws PKIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            byte[] byArray = Base64.encode(this.RStoASN1(session.sign(new Mechanism(signAlg), priKey, fis)));
            return byArray;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    ((InputStream)fis).close();
                }
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
    }

    public byte[] p7SignMessageAttach(String signAlg, byte[] sourceData, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        X509Cert[] certs = new X509Cert[]{cert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.sign(mechanism, priKey, sourceData);
        return Base64.encode(p7.packageSignedData(true, null, sourceData, signture, mechanism, certs));
    }

    public byte[] p7SignMessageDetach(String signAlg, byte[] sourceData, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        X509Cert[] certs = new X509Cert[]{cert};
        Mechanism mechanism = new Mechanism(signAlg);
        byte[] signture = session.sign(mechanism, priKey, sourceData);
        return Base64.encode(p7.packageSignedData(false, null, sourceData, signture, mechanism, certs));
    }

    public void p7SignFileAttach(String signAlg, String sourceFilePath, String signFilePath, PrivateKey priKey, X509Cert signerCert, Session session) throws PKIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            PKCS7SignedFile p7 = new PKCS7SignedFile(session);
            X509Cert[] certs = new X509Cert[]{signerCert};
            Mechanism mechanism = new Mechanism(signAlg);
            byte[] signture = session.sign(mechanism, priKey, fis);
            fis = new FileInputStream(sourceFilePath);
            p7.packageSignedFile(null, sourceFilePath, signFilePath, signture, mechanism, certs);
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
    }

    public byte[] p7SignFileDetach(String signAlg, String sourceFilePath, PrivateKey priKey, X509Cert cert, Session session) throws PKIException {
        InputStream is = null;
        try {
            PKCS7SignedData p7 = new PKCS7SignedData(session);
            X509Cert[] certs = new X509Cert[]{cert};
            Mechanism mechanism = new Mechanism(signAlg);
            is = new FileInputStream(sourceFilePath);
            byte[] signture = session.sign(mechanism, priKey, is);
            byte[] byArray = Base64.encode(p7.packageSignedData(false, null, null, signture, mechanism, certs));
            return byArray;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public boolean p1VerifyMessage(String signAlg, byte[] sourceData, byte[] signData, PublicKey pubKey, Session session) throws PKIException {
        byte[] asn1RS_RS = null;
        asn1RS_RS = ASN1Parser.isBase64Compatability(signData) ? Base64.decode(signData) : signData;
        if (asn1RS_RS.length == 64 || asn1RS_RS.length >= 128) {
            return session.verify(new Mechanism(signAlg), pubKey, sourceData, asn1RS_RS);
        }
        if (asn1RS_RS.length >= 66 && asn1RS_RS.length <= 72) {
            byte[] signature = this.ASN1toRS(asn1RS_RS);
            return session.verify(new Mechanism(signAlg), pubKey, sourceData, signature);
        }
        throw new PKIException("the sign data is wrong!");
    }

    public boolean p1VerifyFile(String signAlg, String sourceFilePath, byte[] signData, PublicKey pubKey, Session session) throws PKIException {
        InputStream is = null;
        try {
            byte[] asn1RS_RS = Base64.decode(signData);
            is = new FileInputStream(sourceFilePath);
            if (asn1RS_RS.length == 64 || asn1RS_RS.length >= 128) {
                boolean bl = session.verify(new Mechanism(signAlg), pubKey, is, asn1RS_RS);
                return bl;
            }
            if (asn1RS_RS.length >= 66 && asn1RS_RS.length <= 72) {
                byte[] signature = this.ASN1toRS(asn1RS_RS);
                boolean bl = session.verify(new Mechanism(signAlg), pubKey, is, signature);
                return bl;
            }
            try {
                throw new PKIException("the sign data is wrong!");
            }
            catch (Exception e) {
                throw new PKIException(e.getMessage());
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public boolean p7VerifyMessageAttach(byte[] signData, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(signData);
        this.signCert = p7.getSignerX509Cert();
        this.sourceData = p7.getSourceData();
        this.digestAlgorithm = p7.getDigestAlgorithm();
        this.signature = p7.getSignature();
        return p7.verifyP7SignedDataAttach();
    }

    public boolean p7VerifyMessageDetach(byte[] sourceData, byte[] signData, Session session) throws PKIException {
        PKCS7SignedData p7 = new PKCS7SignedData(session);
        p7.loadBase64(signData);
        this.signCert = p7.getSignerX509Cert();
        this.digestAlgorithm = p7.getDigestAlgorithm();
        this.signature = p7.getSignature();
        return p7.verifyP7SignedData(sourceData);
    }

    public boolean p7VerifyFileAttach(String signFilePath, String saveSrcFilePath, Session session) throws PKIException {
        try {
            File f = new File(signFilePath);
            if (f.length() <= 0x3300000L) {
                byte[] temps = FileUtil.getBytesFromFile(signFilePath);
                boolean ret = this.p7VerifyMessageAttach(temps, session);
                if (saveSrcFilePath != null && !saveSrcFilePath.trim().equals("")) {
                    FileOutputStream fos = new FileOutputStream(saveSrcFilePath);
                    FileUtil.writeBytesToFile(this.getSourceData(), fos);
                    fos.close();
                }
                return ret;
            }
            PKCS7SignedFile p7 = new PKCS7SignedFile(session);
            boolean result = p7.verifyP7SignedFile(signFilePath, saveSrcFilePath);
            this.signCert = p7.getSignerX509Cert();
            this.digestAlgorithm = p7.getDigestAlgorithm();
            this.signature = p7.getSignature();
            return result;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
    }

    public boolean p7VerifyFileDetach(String srcFilePath, byte[] signData, Session session) throws PKIException {
        InputStream is = null;
        try {
            PKCS7SignedData p7 = new PKCS7SignedData(session);
            p7.loadBase64(signData);
            this.signCert = p7.getSignerX509Cert();
            this.digestAlgorithm = p7.getDigestAlgorithm();
            this.signature = p7.getSignature();
            is = new FileInputStream(srcFilePath);
            boolean bl = p7.verifyP7SignedData(is);
            return bl;
        }
        catch (Exception e) {
            throw new PKIException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw new PKIException(e.getMessage());
                }
            }
        }
    }

    public String getTimeFromTimeStamp(byte[] bTimeStamp) throws PKIException {
        CMSSignedDataParser sp = null;
        byte[] base64TimeStamp = null;
        try {
            if (ASN1Parser.isBase64Compatability(bTimeStamp)) {
                base64TimeStamp = ASN1Parser.deleteCRLF(bTimeStamp);
            }
            sp = new CMSSignedDataParser((DigestCalculatorProvider)new BcDigestCalculatorProvider(), new ByteArrayInputStream(Base64.decode(base64TimeStamp)));
            SignerInformationStore signers = sp.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            String strSignDate = null;
            while (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                AttributeTable attributeTable = signer.getSignedAttributes();
                Attribute signTimeAttri = attributeTable.get(CMSAttributes.signingTime);
                Time time = Time.getInstance(signTimeAttri.getAttrValues().getObjectAt(0).toASN1Primitive());
                Date signTimeDate = time.getDate();
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                strSignDate = format.format(signTimeDate);
            }
            sp.close();
            return strSignDate;
        }
        catch (Exception ex2) {
            throw new PKIException("850914", "\u89e3\u6790\u6587\u4ef6\u7b7e\u540d\u5931\u8d25 " + ex2.getMessage(), ex2);
        }
    }
}

