/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERInteger;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.TBSCertList;
import cfca.sadk.org.bouncycastle.asn1.x509.Time;
import cfca.sadk.org.bouncycastle.asn1.x509.V2TBSCertListGenerator;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Extensions;
import cfca.sadk.org.bouncycastle.asn1.x509.X509Name;
import cfca.sadk.x509.certificate.X509CRL;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class X509CRLGenerator {
    public static final int UNSPECIFIED = 0;
    public static final int KEY_COMPROMISE = 1;
    public static final int CA_COMPROMISE = 2;
    public static final int AFFILIATION_CHANGED = 3;
    public static final int SUPERSEDED = 4;
    public static final int CESSATION_OF_OPERATION = 5;
    public static final int CERTIFICATE_HOLD = 6;
    public static final int REMOVE_FROM_CRL = 8;
    public static final int PRIVILEGE_WITHDRAWN = 9;
    public static final int AA_COMPROMISE = 10;
    private Mechanism mechanism = null;
    private V2TBSCertListGenerator tbsCRLGen = new V2TBSCertListGenerator();
    private AlgorithmIdentifier sigAlg = null;
    private TBSCertList tbsCRL = null;
    private DERBitString signature = null;
    private String issuerName = null;
    private Date thisUpdate = null;
    private Hashtable extensionSet = new Hashtable();

    public void addRevokeCert(String certSerialNumber, Date revokeTime) {
        BigInteger bigIntSN = new BigInteger(certSerialNumber, 16);
        this.tbsCRLGen.addCRLEntry((ASN1Integer)new DERInteger(bigIntSN), new Time(revokeTime), 0);
    }

    public void addRevokeCert(String certSerialNumber, Date revokeTime, int reason) {
        BigInteger bigIntSN = new BigInteger(certSerialNumber, 16);
        this.tbsCRLGen.addCRLEntry((ASN1Integer)new DERInteger(bigIntSN), new Time(revokeTime), reason);
    }

    public void addRevokeCert(BigInteger certSerialNumber, Date revokeTime) {
        this.tbsCRLGen.addCRLEntry((ASN1Integer)new DERInteger(certSerialNumber), new Time(revokeTime), 0);
    }

    public void addRevokeCert(BigInteger certSerialNumber, Date revokeTime, int reason) {
        this.tbsCRLGen.addCRLEntry((ASN1Integer)new DERInteger(certSerialNumber), new Time(revokeTime), reason);
    }

    public void setIssuer(String issuerName) {
        this.issuerName = issuerName;
        X509Name x509Issuer = new X509Name(issuerName);
        this.tbsCRLGen.setIssuer(x509Issuer);
    }

    public void setThisUpdate(Date thisUpdate) {
        this.thisUpdate = thisUpdate;
        this.tbsCRLGen.setThisUpdate(new Time(thisUpdate));
    }

    public void setNextUpdate(Date nextUpdate) {
        this.tbsCRLGen.setNextUpdate(new Time(nextUpdate));
    }

    public void setSignatureAlg(String signatureAlgorithm) throws PKIException {
        if (signatureAlgorithm == null) {
            throw new PKIException(PKIException.SIG_ALG_NULL, PKIException.SIG_ALG_NULL_DES);
        }
        if ("sha1WithRSAEncryption".equals(signatureAlgorithm)) {
            this.mechanism = new Mechanism("sha1WithRSAEncryption");
        } else if ("sha256WithRSAEncryption".equals(signatureAlgorithm)) {
            this.mechanism = new Mechanism("sha256WithRSAEncryption");
        } else if ("sha512WithRSAEncryption".equals(signatureAlgorithm)) {
            this.mechanism = new Mechanism("sha512WithRSAEncryption");
        } else if ("sm3WithSM2Encryption".equals(signatureAlgorithm)) {
            this.mechanism = new Mechanism("sm3WithSM2Encryption");
        } else {
            throw new PKIException(PKIException.NONSUPPORT_SIGALG, PKIException.NONSUPPORT_SIGALG_DES + ": " + signatureAlgorithm);
        }
        ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)Mechanism.ALGOIDMap.get(signatureAlgorithm);
        this.sigAlg = new AlgorithmIdentifier(oid);
        this.tbsCRLGen.setSignature(this.sigAlg);
    }

    public void addExtensions(Vector extensions) throws PKIException {
        int size = extensions.size();
        for (int i = 0; i < size; ++i) {
            Extension extension = (Extension)extensions.get(i);
            this.addExtension(extension);
        }
    }

    public void addExtension(Extension extension) throws PKIException {
        ASN1ObjectIdentifier derOID = extension.getExtnId();
        boolean critical = extension.isCritical();
        DEROctetString derOctet = (DEROctetString)extension.getExtnValue();
        this.extensionSet.put(derOID, new X509Extension(critical, (ASN1OctetString)derOctet));
    }

    public byte[] generateCRL(PrivateKey priKey, Session session) throws PKIException {
        if (this.issuerName == null || this.issuerName.equals("")) {
            throw new PKIException(PKIException.ISSUER_NULL, PKIException.ISSUER_NULL_DES);
        }
        if (this.thisUpdate == null) {
            throw new PKIException(PKIException.THIS_UPDATE_NULL, PKIException.THIS_UPDATE_NULL_DES);
        }
        if (this.sigAlg == null) {
            throw new PKIException(PKIException.SIG_ALG_NULL, PKIException.SIG_ALG_NULL_DES);
        }
        this.generateSignature(priKey, session);
        return this.constructCRL();
    }

    private void generateSignature(PrivateKey priKey, Session session) throws PKIException {
        if (this.extensionSet.size() > 0) {
            this.tbsCRLGen.setExtensions(new X509Extensions(this.extensionSet));
        }
        this.tbsCRL = this.tbsCRLGen.generateTBSCertList();
        byte[] bTBSCRL = null;
        try {
            bTBSCRL = ASN1Parser.parseDERObj2Bytes(this.tbsCRL.toASN1Primitive());
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.TBSCRL_BYTES, PKIException.TBSCRL_BYTES_DES, ex);
        }
        byte[] signatureData = null;
        try {
            signatureData = session.sign(this.mechanism, priKey, bTBSCRL);
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.SIGN, PKIException.SIGN_DES, ex);
        }
        this.signature = new DERBitString(signatureData);
    }

    private byte[] constructCRL() throws PKIException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.tbsCRL);
        v.add(this.sigAlg);
        v.add(this.signature);
        DERSequence derSeq = new DERSequence(v);
        byte[] certData = null;
        try {
            certData = ASN1Parser.parseDERObj2Bytes(derSeq.toASN1Primitive());
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.CRL_BYTES, PKIException.CRL_BYTES_DES, ex);
        }
        return certData;
    }

    public static void main(String[] args) {
        X509CRLGenerator x509CRLGenerator = new X509CRLGenerator();
        try {
            JCrypto jCrypto = JCrypto.getInstance();
            jCrypto.initialize("JSOFT_LIB", null);
            Session session = jCrypto.openSession("JSOFT_LIB");
            GenKeyAttribute attr = new GenKeyAttribute();
            attr.isExport = false;
            attr.keyNum = 1;
            Mechanism mech = new Mechanism("SM2");
            mech.setParam(attr);
            KeyPair keyPair = session.generateKeyPair(mech, 256);
            PrivateKey priKey = keyPair.getPrivate();
            PublicKey PubKey = keyPair.getPublic();
            x509CRLGenerator.setIssuer("CN=IDA,C=CN");
            x509CRLGenerator.setThisUpdate(new Date());
            x509CRLGenerator.setNextUpdate(new Date(System.currentTimeMillis() + 0x6DDD00L));
            x509CRLGenerator.setSignatureAlg("sm3WithSM2Encryption");
            x509CRLGenerator.addRevokeCert("a11111111111111", new Date(), 2);
            x509CRLGenerator.addRevokeCert("b22222222222222", new Date());
            Extension extension = new Extension(X509Extensions.CRLNumber, true, (ASN1OctetString)new DEROctetString(new BigInteger("500").toByteArray()));
            x509CRLGenerator.addExtension(extension);
            byte[] actualReturn = x509CRLGenerator.generateCRL(priKey, session);
            FileOutputStream fos = new FileOutputStream("./TestData/newCRL.crl");
            fos.write(actualReturn);
            fos.flush();
            fos.close();
            X509CRL crl = new X509CRL(actualReturn);
            boolean verify = crl.verify(keyPair.getPublic());
            String issuer = crl.getIssuer();
            String signatureAlgName = crl.getSignatureAlgName();
            Date thisUpdate = crl.getThisUpdate();
            boolean isRevoke = crl.isRevoke("a11111111111111");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

