/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen;

import com.mybatisflex.codegen.config.GlobalConfig;
import com.mybatisflex.codegen.config.StrategyConfig;
import com.mybatisflex.codegen.dialect.IDialect;
import com.mybatisflex.codegen.entity.Table;
import com.mybatisflex.codegen.generator.GeneratorFactory;
import com.mybatisflex.codegen.generator.IGenerator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class Generator {
    protected DataSource dataSource;
    protected GlobalConfig globalConfig;
    protected IDialect dialect = IDialect.DEFAULT;
    protected DatabaseMetaData dbMeta = null;

    public Generator(DataSource dataSource, GlobalConfig globalConfig) {
        this.dataSource = dataSource;
        this.globalConfig = globalConfig;
    }

    public Generator(DataSource dataSource, GlobalConfig globalConfig, IDialect dialect) {
        this.dataSource = dataSource;
        this.globalConfig = globalConfig;
        this.dialect = dialect;
    }

    public void generate() {
        try (Connection conn = this.dataSource.getConnection();){
            this.dbMeta = conn.getMetaData();
            List<Table> tables = this.buildTables(conn);
            if (tables.isEmpty()) {
                System.err.printf("table %s not found.%n", this.globalConfig.getGenerateTables());
                return;
            }
            System.out.printf("find tables: %s%n", tables.stream().map(Table::getName).collect(Collectors.toSet()));
            for (Table table : tables) {
                Collection<IGenerator> generators = GeneratorFactory.getGenerators();
                for (IGenerator generator : generators) {
                    generator.generate(table, this.globalConfig);
                }
            }
            System.out.println("Code is generated successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void buildPrimaryKey(Connection conn, Table table) throws SQLException {
        try (ResultSet rs = this.dbMeta.getPrimaryKeys(conn.getCatalog(), null, table.getName());){
            while (rs.next()) {
                String primaryKey = rs.getString("COLUMN_NAME");
                table.addPrimaryKey(primaryKey);
            }
        }
    }

    private List<Table> buildTables(Connection conn) throws SQLException {
        StrategyConfig strategyConfig = this.globalConfig.getStrategyConfig();
        String schemaName = strategyConfig.getGenerateSchema();
        ArrayList<Table> tables = new ArrayList<Table>();
        try (ResultSet rs = this.getTablesResultSet(conn, schemaName);){
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                if (!strategyConfig.isSupportGenerate(tableName)) continue;
                Table table = new Table();
                table.setGlobalConfig(this.globalConfig);
                table.setTableConfig(strategyConfig.getTableConfig(tableName));
                table.setSchema(schemaName);
                table.setName(tableName);
                String remarks = rs.getString("REMARKS");
                table.setComment(remarks);
                this.buildPrimaryKey(conn, table);
                this.dialect.buildTableColumns(schemaName, table, this.globalConfig, this.dbMeta, conn);
                tables.add(table);
            }
        }
        return tables;
    }

    protected ResultSet getTablesResultSet(Connection conn, String schema) throws SQLException {
        if (this.globalConfig.getStrategyConfig().isGenerateForView()) {
            return this.dialect.getTablesResultSet(this.dbMeta, conn, schema, new String[]{"TABLE", "VIEW"});
        }
        return this.dialect.getTablesResultSet(this.dbMeta, conn, schema, new String[]{"TABLE"});
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public Generator setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public Generator setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public IDialect getDialect() {
        return this.dialect;
    }

    public Generator setDialect(IDialect dialect) {
        this.dialect = dialect;
        return this;
    }
}

