/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.codegen.config;

import com.mybatisflex.core.util.StringUtil;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class JavadocConfig
implements Serializable {
    private static final long serialVersionUID = -4280345489968397327L;
    private String author = System.getProperty("user.name");
    private Supplier<String> since = () -> DateTimeFormatter.ofPattern("yyyy-MM-dd").format(LocalDate.now());
    private UnaryOperator<String> tableCommentFormat = UnaryOperator.identity();
    private UnaryOperator<String> columnCommentFormat = UnaryOperator.identity();
    private String entityPackage = "\u5b9e\u4f53\u7c7b\u5c42\uff08Entity\uff09\u8f6f\u4ef6\u5305\u3002";
    private String mapperPackage = "\u6620\u5c04\u5c42\uff08Mapper\uff09\u8f6f\u4ef6\u5305\u3002";
    private String servicePackage = "\u670d\u52a1\u5c42\uff08Service\uff09\u8f6f\u4ef6\u5305\u3002";
    private String serviceImplPackage = "\u670d\u52a1\u5c42\u5b9e\u73b0\uff08ServiceImpl\uff09\u8f6f\u4ef6\u5305\u3002";
    private String controllerPackage = "\u63a7\u5236\u5c42\uff08Controller\uff09\u8f6f\u4ef6\u5305\u3002";
    private String tableDefPackage = "\u8868\u5b9a\u4e49\u5c42\uff08TableDef\uff09\u8f6f\u4ef6\u5305\u3002";

    public String getAuthor() {
        return this.author;
    }

    public JavadocConfig setAuthor(String author) {
        this.author = author;
        return this;
    }

    public String getSince() {
        return this.since.get();
    }

    public JavadocConfig setSince(String since) {
        this.since = () -> since;
        return this;
    }

    public JavadocConfig setSince(Supplier<String> since) {
        this.since = since;
        return this;
    }

    public String formatTableComment(String comment) {
        if (StringUtil.isBlank((String)comment)) {
            return "";
        }
        return (String)this.tableCommentFormat.apply(comment);
    }

    public Function<String, String> getTableCommentFormat() {
        return this.tableCommentFormat;
    }

    public JavadocConfig setTableCommentFormat(UnaryOperator<String> tableCommentFormat) {
        this.tableCommentFormat = tableCommentFormat;
        return this;
    }

    public String formatColumnComment(String comment) {
        if (StringUtil.isBlank((String)comment)) {
            return "";
        }
        return (String)this.columnCommentFormat.apply(comment);
    }

    public Function<String, String> getColumnCommentFormat() {
        return this.columnCommentFormat;
    }

    public JavadocConfig setColumnCommentFormat(UnaryOperator<String> columnCommentFormat) {
        this.columnCommentFormat = columnCommentFormat;
        return this;
    }

    public String getEntityPackage() {
        return this.entityPackage;
    }

    public JavadocConfig setEntityPackage(String entityPackage) {
        this.entityPackage = entityPackage;
        return this;
    }

    public String getMapperPackage() {
        return this.mapperPackage;
    }

    public JavadocConfig setMapperPackage(String mapperPackage) {
        this.mapperPackage = mapperPackage;
        return this;
    }

    public String getServicePackage() {
        return this.servicePackage;
    }

    public JavadocConfig setServicePackage(String servicePackage) {
        this.servicePackage = servicePackage;
        return this;
    }

    public String getServiceImplPackage() {
        return this.serviceImplPackage;
    }

    public JavadocConfig setServiceImplPackage(String serviceImplPackage) {
        this.serviceImplPackage = serviceImplPackage;
        return this;
    }

    public String getControllerPackage() {
        return this.controllerPackage;
    }

    public JavadocConfig setControllerPackage(String controllerPackage) {
        this.controllerPackage = controllerPackage;
        return this;
    }

    public String getTableDefPackage() {
        return this.tableDefPackage;
    }

    public JavadocConfig setTableDefPackage(String tableDefPackage) {
        this.tableDefPackage = tableDefPackage;
        return this;
    }
}

