/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.dialect.impl;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.dialect.KeywordWrap;
import com.mybatisflex.core.dialect.LimitOffsetProcessor;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.exception.locale.LocalizedFormats;
import com.mybatisflex.core.logicdelete.LogicDeleteManager;
import com.mybatisflex.core.query.CPI;
import com.mybatisflex.core.query.Join;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryOrderBy;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.SelectQueryTable;
import com.mybatisflex.core.query.UnionWrapper;
import com.mybatisflex.core.query.With;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowCPI;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.update.RawValue;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.SqlUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;

public class CommonsDialectImpl
implements IDialect {
    protected KeywordWrap keywordWrap = KeywordWrap.BACK_QUOTE;
    private LimitOffsetProcessor limitOffsetProcessor = LimitOffsetProcessor.MYSQL;

    public CommonsDialectImpl() {
    }

    public CommonsDialectImpl(LimitOffsetProcessor limitOffsetProcessor) {
        this.limitOffsetProcessor = limitOffsetProcessor;
    }

    public CommonsDialectImpl(KeywordWrap keywordWrap, LimitOffsetProcessor limitOffsetProcessor) {
        this.keywordWrap = keywordWrap;
        this.limitOffsetProcessor = limitOffsetProcessor;
    }

    @Override
    public String wrap(String keyword) {
        return "*".equals(keyword) ? keyword : this.keywordWrap.wrap(keyword);
    }

    @Override
    public String wrapColumnAlias(String keyword) {
        return "*".equals(keyword) ? keyword : this.keywordWrap.getPrefix() + keyword + this.keywordWrap.getSuffix();
    }

    @Override
    public String forHint(String hintString) {
        return StringUtil.isNotBlank(hintString) ? "/*+ " + hintString + " */ " : "";
    }

    @Override
    public String forInsertRow(String schema, String tableName, Row row) {
        StringBuilder fields = new StringBuilder();
        StringBuilder paramsOrPlaceholder = new StringBuilder();
        Set<String> modifyAttrs = RowCPI.getInsertAttrs(row);
        int index = 0;
        for (String attr : modifyAttrs) {
            fields.append(this.wrap(attr));
            Object value = row.get(attr);
            if (value instanceof RawValue) {
                paramsOrPlaceholder.append(((RawValue)value).toSql(this));
            } else {
                paramsOrPlaceholder.append("?");
            }
            if (index != modifyAttrs.size() - 1) {
                fields.append(", ");
                paramsOrPlaceholder.append(", ");
            }
            ++index;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        if (StringUtil.isNotBlank(schema)) {
            sql.append(this.wrap(this.getRealSchema(schema))).append(".");
        }
        sql.append(this.wrap(this.getRealTable(tableName)));
        sql.append("(").append((CharSequence)fields).append(")");
        sql.append(" VALUES ").append("(").append((CharSequence)paramsOrPlaceholder).append(")");
        return sql.toString();
    }

    @Override
    public String forInsertBatchWithFirstRowColumns(String schema, String tableName, List<Row> rows) {
        StringBuilder fields = new StringBuilder();
        StringBuilder questions = new StringBuilder();
        Row firstRow = rows.get(0);
        Set<String> attrs = RowCPI.getInsertAttrs(firstRow);
        int index = 0;
        for (String column : attrs) {
            fields.append(this.wrap(column));
            if (index != attrs.size() - 1) {
                fields.append(", ");
            }
            ++index;
        }
        for (int i = 0; i < rows.size(); ++i) {
            questions.append(SqlUtil.buildSqlParamPlaceholder(attrs.size()));
            if (i == rows.size() - 1) continue;
            questions.append(", ");
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        if (StringUtil.isNotBlank(schema)) {
            sql.append(this.wrap(this.getRealSchema(schema))).append(".");
        }
        sql.append(this.wrap(this.getRealTable(tableName)));
        sql.append(" ").append("(").append((CharSequence)fields).append(")").append(" ");
        sql.append(" VALUES ").append((CharSequence)questions);
        return sql.toString();
    }

    @Override
    public String forDeleteById(String schema, String tableName, String[] primaryKeys) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        if (StringUtil.isNotBlank(schema)) {
            sql.append(this.wrap(this.getRealSchema(schema))).append(".");
        }
        sql.append(this.wrap(this.getRealTable(tableName)));
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ? ");
        }
        return sql.toString();
    }

    @Override
    public String forDeleteBatchByIds(String schema, String tableName, String[] primaryKeys, Object[] ids) {
        StringBuilder sql = new StringBuilder();
        sql.append("DELETE FROM ");
        if (StringUtil.isNotBlank(schema)) {
            sql.append(this.wrap(this.getRealSchema(schema))).append(".");
        }
        sql.append(this.wrap(this.getRealTable(tableName)));
        sql.append(" WHERE ");
        if (primaryKeys.length > 1) {
            for (int i = 0; i < ids.length / primaryKeys.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append("(");
                for (int j = 0; j < primaryKeys.length; ++j) {
                    if (j > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.wrap(primaryKeys[j])).append(" = ? ");
                }
                sql.append(")");
            }
        } else {
            for (int i = 0; i < ids.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(this.wrap(primaryKeys[0])).append(" = ? ");
            }
        }
        return sql.toString();
    }

    @Override
    public String forDeleteByQuery(QueryWrapper queryWrapper) {
        return this.buildDeleteSql(queryWrapper);
    }

    @Override
    public String forUpdateById(String schema, String tableName, Row row) {
        StringBuilder sql = new StringBuilder();
        Set<String> modifyAttrs = RowCPI.getModifyAttrs(row);
        Map<String, RawValue> rawValueMap = RowCPI.getRawValueMap(row);
        String[] primaryKeys = RowCPI.obtainsPrimaryKeyStrings(row);
        sql.append("UPDATE ");
        if (StringUtil.isNotBlank(schema)) {
            sql.append(this.wrap(this.getRealSchema(schema))).append(".");
        }
        sql.append(this.wrap(this.getRealTable(tableName))).append(" SET ");
        int index = 0;
        for (Map.Entry e : row.entrySet()) {
            String colName = (String)e.getKey();
            if (!modifyAttrs.contains(colName) || ArrayUtil.contains(primaryKeys, colName)) continue;
            if (index > 0) {
                sql.append(", ");
            }
            sql.append(this.wrap(colName));
            if (rawValueMap.containsKey(colName)) {
                sql.append(" = ").append(rawValueMap.get(colName).toSql(this));
            } else {
                sql.append(" = ? ");
            }
            ++index;
        }
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ? ");
        }
        return sql.toString();
    }

    @Override
    public String forUpdateByQuery(QueryWrapper queryWrapper, Row row) {
        StringBuilder sqlBuilder = new StringBuilder();
        Set<String> modifyAttrs = RowCPI.getModifyAttrs(row);
        Map<String, RawValue> rawValueMap = RowCPI.getRawValueMap(row);
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        if (queryTables == null || queryTables.size() != 1) {
            throw FlexExceptions.wrap(LocalizedFormats.UPDATE_ONLY_SUPPORT_1_TABLE, new Object[0]);
        }
        QueryTable queryTable = queryTables.get(0);
        sqlBuilder.append("UPDATE ").append(queryTable.toSql(this)).append(" SET ");
        int index = 0;
        for (String modifyAttr : modifyAttrs) {
            if (index > 0) {
                sqlBuilder.append(", ");
            }
            sqlBuilder.append(this.wrap(modifyAttr));
            if (rawValueMap.containsKey(modifyAttr)) {
                sqlBuilder.append(" = ").append(rawValueMap.get(modifyAttr).toSql(this));
            } else {
                sqlBuilder.append(" = ? ");
            }
            ++index;
        }
        this.buildJoinSql(sqlBuilder, queryWrapper, queryTables);
        this.buildWhereSql(sqlBuilder, queryWrapper, queryTables, false);
        this.buildGroupBySql(sqlBuilder, queryWrapper, queryTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, queryTables);
        this.buildOrderBySql(sqlBuilder, queryWrapper, queryTables);
        Long limitRows = CPI.getLimitRows(queryWrapper);
        Long limitOffset = CPI.getLimitOffset(queryWrapper);
        if (limitRows != null || limitOffset != null) {
            sqlBuilder = this.buildLimitOffsetSql(sqlBuilder, queryWrapper, limitRows, limitOffset);
        }
        return sqlBuilder.toString();
    }

    @Override
    public String forUpdateBatchById(String schema, String tableName, List<Row> rows) {
        if (rows.size() == 1) {
            return this.forUpdateById(schema, tableName, rows.get(0));
        }
        StringBuilder sql = new StringBuilder();
        for (Row row : rows) {
            sql.append(this.forUpdateById(schema, tableName, row)).append(";").append(" ");
        }
        return sql.toString();
    }

    @Override
    public String forSelectOneById(String schema, String tableName, String[] primaryKeys, Object[] primaryValues) {
        StringBuilder sql = new StringBuilder("SELECT * FROM ");
        if (StringUtil.isNotBlank(schema)) {
            sql.append(this.wrap(this.getRealSchema(schema))).append(".");
        }
        sql.append(this.wrap(this.getRealTable(tableName))).append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ? ");
        }
        return sql.toString();
    }

    @Override
    public String forSelectByQuery(QueryWrapper queryWrapper) {
        return this.buildSelectSql(queryWrapper);
    }

    @Override
    public String buildSelectSql(QueryWrapper queryWrapper) {
        List<String> endFragments;
        TableInfo tableInfo;
        QueryTable firstTable;
        int joinTablesCount;
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        List<QueryColumn> selectColumns = CPI.getSelectColumns(queryWrapper);
        int queryTablesCount = queryTables == null ? 0 : queryTables.size();
        int n = joinTablesCount = joinTables != null ? joinTables.size() : 0;
        if (queryTablesCount > 0 && queryTablesCount + joinTablesCount > 1 && !((firstTable = queryTables.get(0)) instanceof SelectQueryTable) && (tableInfo = TableInfoFactory.ofTableName(firstTable.getName())) != null && selectColumns != null && !selectColumns.isEmpty()) {
            String[] firstTableColumns = tableInfo.getAllColumns();
            for (int i = 0; i < selectColumns.size(); ++i) {
                QueryColumn selectColumn = selectColumns.get(i);
                QueryTable selectColumnTable = selectColumn.getTable();
                String selectColumnName = selectColumn.getName();
                if (selectColumnTable == null || selectColumnName == null || "*".equals(selectColumnName) || !StringUtil.isBlank(selectColumn.getAlias()) || selectColumnTable instanceof SelectQueryTable || CPI.isSameTable(firstTable, selectColumnTable) || !ArrayUtil.contains(firstTableColumns, selectColumnName)) continue;
                QueryColumn newSelectColumn = selectColumn.as(selectColumnTable.getName() + "$" + selectColumnName);
                selectColumns.set(i, newSelectColumn);
            }
        }
        StringBuilder sqlBuilder = new StringBuilder();
        With with = CPI.getWith(queryWrapper);
        if (with != null) {
            sqlBuilder.append(with.toSql(this));
        }
        this.buildSelectColumnSql(sqlBuilder, allTables, selectColumns, CPI.getHint(queryWrapper));
        sqlBuilder.append(" FROM ").append(StringUtil.join(", ", queryTables, queryTable -> queryTable.toSql(this)));
        this.buildJoinSql(sqlBuilder, queryWrapper, allTables);
        this.buildWhereSql(sqlBuilder, queryWrapper, allTables, true);
        this.buildGroupBySql(sqlBuilder, queryWrapper, allTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, allTables);
        this.buildOrderBySql(sqlBuilder, queryWrapper, allTables);
        List<UnionWrapper> unions = CPI.getUnions(queryWrapper);
        if (CollectionUtil.isNotEmpty(unions)) {
            sqlBuilder.insert(0, "(").append(")");
            for (UnionWrapper unionWrapper : unions) {
                unionWrapper.buildSql(sqlBuilder, this);
            }
        }
        Long limitRows = CPI.getLimitRows(queryWrapper);
        Long limitOffset = CPI.getLimitOffset(queryWrapper);
        if (limitRows != null || limitOffset != null) {
            sqlBuilder = this.buildLimitOffsetSql(sqlBuilder, queryWrapper, limitRows, limitOffset);
        }
        if (CollectionUtil.isNotEmpty(endFragments = CPI.getEndFragments(queryWrapper))) {
            for (String endFragment : endFragments) {
                sqlBuilder.append(" ").append(endFragment);
            }
        }
        return sqlBuilder.toString();
    }

    @Override
    public String buildNoSelectSql(QueryWrapper queryWrapper) {
        List<String> endFragments;
        StringBuilder sqlBuilder = new StringBuilder();
        this.buildJoinSql(sqlBuilder, queryWrapper, Collections.EMPTY_LIST);
        this.buildWhereSql(sqlBuilder, queryWrapper, Collections.EMPTY_LIST, true);
        this.buildGroupBySql(sqlBuilder, queryWrapper, Collections.EMPTY_LIST);
        this.buildHavingSql(sqlBuilder, queryWrapper, Collections.EMPTY_LIST);
        this.buildOrderBySql(sqlBuilder, queryWrapper, Collections.EMPTY_LIST);
        List<UnionWrapper> unions = CPI.getUnions(queryWrapper);
        if (CollectionUtil.isNotEmpty(unions)) {
            if (sqlBuilder.length() > 0) {
                sqlBuilder.insert(0, "(").append(")");
            }
            for (UnionWrapper unionWrapper : unions) {
                unionWrapper.buildSql(sqlBuilder, this);
            }
        }
        Long limitRows = CPI.getLimitRows(queryWrapper);
        Long limitOffset = CPI.getLimitOffset(queryWrapper);
        if (limitRows != null || limitOffset != null) {
            sqlBuilder = this.buildLimitOffsetSql(sqlBuilder, queryWrapper, limitRows, limitOffset);
        }
        if (CollectionUtil.isNotEmpty(endFragments = CPI.getEndFragments(queryWrapper))) {
            for (String endFragment : endFragments) {
                sqlBuilder.append(" ").append(endFragment);
            }
        }
        return sqlBuilder.toString();
    }

    private void buildSelectColumnSql(StringBuilder sqlBuilder, List<QueryTable> queryTables, List<QueryColumn> selectColumns, String hint) {
        sqlBuilder.append("SELECT ");
        sqlBuilder.append(this.forHint(hint));
        if (selectColumns == null || selectColumns.isEmpty()) {
            sqlBuilder.append("*");
        } else {
            int index = 0;
            for (QueryColumn selectColumn : selectColumns) {
                String selectColumnSql = CPI.toSelectSql(selectColumn, queryTables, this);
                sqlBuilder.append(selectColumnSql);
                if (index != selectColumns.size() - 1) {
                    sqlBuilder.append(", ");
                }
                ++index;
            }
        }
    }

    @Override
    public String buildDeleteSql(QueryWrapper queryWrapper) {
        List<String> endFragments;
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        StringBuilder sqlBuilder = new StringBuilder("DELETE");
        String hint = CPI.getHint(queryWrapper);
        if (StringUtil.isNotBlank(hint)) {
            sqlBuilder.append(" ").append(hint).deleteCharAt(sqlBuilder.length() - 1);
        }
        sqlBuilder.append(" FROM ").append(StringUtil.join(", ", queryTables, queryTable -> queryTable.toSql(this)));
        this.buildJoinSql(sqlBuilder, queryWrapper, allTables);
        this.buildWhereSql(sqlBuilder, queryWrapper, allTables, false);
        this.buildGroupBySql(sqlBuilder, queryWrapper, allTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, allTables);
        this.buildOrderBySql(sqlBuilder, queryWrapper, allTables);
        Long limitRows = CPI.getLimitRows(queryWrapper);
        Long limitOffset = CPI.getLimitOffset(queryWrapper);
        if (limitRows != null || limitOffset != null) {
            sqlBuilder = this.buildLimitOffsetSql(sqlBuilder, queryWrapper, limitRows, limitOffset);
        }
        if (CollectionUtil.isNotEmpty(endFragments = CPI.getEndFragments(queryWrapper))) {
            for (String endFragment : endFragments) {
                sqlBuilder.append(" ").append(endFragment);
            }
        }
        return sqlBuilder.toString();
    }

    @Override
    public String buildWhereConditionSql(QueryWrapper queryWrapper) {
        QueryCondition whereQueryCondition = CPI.getWhereQueryCondition(queryWrapper);
        return whereQueryCondition != null ? whereQueryCondition.toSql(CPI.getQueryTables(queryWrapper), this) : "";
    }

    @Override
    public String forInsertEntity(TableInfo tableInfo, Object entity, boolean ignoreNulls) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(tableInfo.getWrapSchemaAndTableName(this));
        String[] insertColumns = tableInfo.obtainInsertColumns(entity, ignoreNulls);
        Map<String, String> onInsertColumns = tableInfo.getOnInsertColumns();
        Map<String, RawValue> rawValueMap = tableInfo.obtainUpdateRawValueMap(entity);
        StringJoiner sqlFields = new StringJoiner(", ");
        StringJoiner sqlValues = new StringJoiner(", ");
        for (String insertColumn : insertColumns) {
            sqlFields.add(this.wrap(insertColumn));
            if (rawValueMap.containsKey(insertColumn)) {
                sqlValues.add(rawValueMap.get(insertColumn).toSql(this));
                continue;
            }
            if (onInsertColumns != null && onInsertColumns.containsKey(insertColumn)) {
                sqlValues.add(onInsertColumns.get(insertColumn));
                continue;
            }
            sqlValues.add("?");
        }
        return sql.append("(").append(sqlFields).append(")").append(" VALUES ").append("(").append(sqlValues).append(")").toString();
    }

    @Override
    public String forInsertEntityWithPk(TableInfo tableInfo, Object entity, boolean ignoreNulls) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(tableInfo.getWrapSchemaAndTableName(this));
        String[] insertColumns = tableInfo.obtainInsertColumnsWithPk(entity, ignoreNulls);
        Map<String, String> onInsertColumns = tableInfo.getOnInsertColumns();
        StringJoiner sqlFields = new StringJoiner(", ");
        StringJoiner sqlValues = new StringJoiner(", ");
        for (String insertColumn : insertColumns) {
            sqlFields.add(this.wrap(insertColumn));
            if (onInsertColumns != null && onInsertColumns.containsKey(insertColumn)) {
                sqlValues.add(onInsertColumns.get(insertColumn));
                continue;
            }
            sqlValues.add("?");
        }
        return sql.append("(").append(sqlFields).append(")").append(" VALUES ").append("(").append(sqlValues).append(")").toString();
    }

    @Override
    public String forInsertEntityBatch(TableInfo tableInfo, List<?> entities) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ").append(tableInfo.getWrapSchemaAndTableName(this));
        String[] insertColumns = tableInfo.obtainInsertColumns(null, false);
        CharSequence[] warpedInsertColumns = new String[insertColumns.length];
        for (int i = 0; i < insertColumns.length; ++i) {
            warpedInsertColumns[i] = this.wrap(insertColumns[i]);
        }
        sql.append("(").append(StringUtil.join(", ", warpedInsertColumns)).append(")");
        sql.append(" VALUES ");
        Map<String, String> onInsertColumns = tableInfo.getOnInsertColumns();
        for (int i = 0; i < entities.size(); ++i) {
            StringJoiner stringJoiner = new StringJoiner(", ", "(", ")");
            for (String insertColumn : insertColumns) {
                if (onInsertColumns != null && onInsertColumns.containsKey(insertColumn)) {
                    stringJoiner.add(onInsertColumns.get(insertColumn));
                    continue;
                }
                stringJoiner.add("?");
            }
            sql.append(stringJoiner);
            if (i == entities.size() - 1) continue;
            sql.append(", ");
        }
        return sql.toString();
    }

    @Override
    public String forDeleteEntityById(TableInfo tableInfo) {
        String logicDeleteColumn = tableInfo.getLogicDeleteColumnOrSkip();
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        if (StringUtil.isBlank(logicDeleteColumn)) {
            String deleteByIdSql = this.forDeleteById(tableInfo.getSchema(), tableInfo.getTableName(), tableInfo.getPrimaryColumns());
            return tableInfo.buildTenantCondition(deleteByIdSql, tenantIdArgs, (IDialect)this);
        }
        StringBuilder sql = new StringBuilder();
        String[] primaryKeys = tableInfo.getPrimaryColumns();
        sql.append("UPDATE ").append(tableInfo.getWrapSchemaAndTableName(this));
        sql.append(" SET ").append(this.buildLogicDeletedSet(logicDeleteColumn, tableInfo));
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ? ");
        }
        sql.append(" AND ").append(this.buildLogicNormalCondition(logicDeleteColumn, tableInfo));
        tableInfo.buildTenantCondition(sql, tenantIdArgs, (IDialect)this);
        return sql.toString();
    }

    @Override
    public String forDeleteEntityBatchByIds(TableInfo tableInfo, Object[] primaryValues) {
        String logicDeleteColumn = tableInfo.getLogicDeleteColumnOrSkip();
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        if (StringUtil.isBlank(logicDeleteColumn)) {
            String deleteSQL = this.forDeleteBatchByIds(tableInfo.getSchema(), tableInfo.getTableName(), tableInfo.getPrimaryColumns(), primaryValues);
            if (ArrayUtil.isNotEmpty(tenantIdArgs)) {
                deleteSQL = deleteSQL.replace(" WHERE ", " WHERE (") + ")";
                deleteSQL = tableInfo.buildTenantCondition(deleteSQL, tenantIdArgs, (IDialect)this);
            }
            return deleteSQL;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(tableInfo.getWrapSchemaAndTableName(this));
        sql.append(" SET ").append(this.buildLogicDeletedSet(logicDeleteColumn, tableInfo));
        sql.append(" WHERE ");
        sql.append("(");
        String[] primaryKeys = tableInfo.getPrimaryColumns();
        if (primaryKeys.length > 1) {
            for (int i = 0; i < primaryValues.length / primaryKeys.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append("(");
                for (int j = 0; j < primaryKeys.length; ++j) {
                    if (j > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.wrap(primaryKeys[j])).append(" = ? ");
                }
                sql.append(")");
            }
        } else {
            for (int i = 0; i < primaryValues.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(this.wrap(primaryKeys[0])).append(" = ? ");
            }
        }
        sql.append(")").append(" AND ").append(this.buildLogicNormalCondition(logicDeleteColumn, tableInfo));
        tableInfo.buildTenantCondition(sql, tenantIdArgs, (IDialect)this);
        return sql.toString();
    }

    @Override
    public String forDeleteEntityBatchByQuery(TableInfo tableInfo, QueryWrapper queryWrapper) {
        String logicDeleteColumn = tableInfo.getLogicDeleteColumnOrSkip();
        if (StringUtil.isBlank(logicDeleteColumn)) {
            return this.forDeleteByQuery(queryWrapper);
        }
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        StringBuilder sqlBuilder = new StringBuilder("UPDATE ").append(this.forHint(CPI.getHint(queryWrapper)));
        sqlBuilder.append(tableInfo.getWrapSchemaAndTableName(this));
        sqlBuilder.append(" SET ").append(this.buildLogicDeletedSet(logicDeleteColumn, tableInfo));
        this.buildJoinSql(sqlBuilder, queryWrapper, allTables);
        this.buildWhereSql(sqlBuilder, queryWrapper, allTables, false);
        this.buildGroupBySql(sqlBuilder, queryWrapper, allTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, allTables);
        return sqlBuilder.toString();
    }

    @Override
    public String forUpdateEntity(TableInfo tableInfo, Object entity, boolean ignoreNulls) {
        String versionColumn;
        StringBuilder sql = new StringBuilder();
        Set<String> updateColumns = tableInfo.obtainUpdateColumns(entity, ignoreNulls, false);
        Map<String, RawValue> rawValueMap = tableInfo.obtainUpdateRawValueMap(entity);
        String[] primaryKeys = tableInfo.getPrimaryColumns();
        sql.append("UPDATE ").append(tableInfo.getWrapSchemaAndTableName(this)).append(" SET ");
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (String updateColumn : updateColumns) {
            if (rawValueMap.containsKey(updateColumn)) {
                stringJoiner.add(this.wrap(updateColumn) + " = " + rawValueMap.get(updateColumn).toSql(this));
                continue;
            }
            stringJoiner.add(this.wrap(updateColumn) + " = ? ");
        }
        Map<String, String> onUpdateColumns = tableInfo.getOnUpdateColumns();
        if (onUpdateColumns != null && !onUpdateColumns.isEmpty()) {
            onUpdateColumns.forEach((column, value) -> stringJoiner.add(this.wrap((String)column) + " = " + value));
        }
        if (StringUtil.isNotBlank(versionColumn = tableInfo.getVersionColumn())) {
            stringJoiner.add(this.wrap(versionColumn) + " = " + this.wrap(versionColumn) + " + 1 ");
        }
        sql.append(stringJoiner);
        sql.append(" WHERE ");
        for (int i = 0; i < primaryKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(primaryKeys[i])).append(" = ? ");
        }
        String logicDeleteColumn = tableInfo.getLogicDeleteColumnOrSkip();
        if (StringUtil.isNotBlank(logicDeleteColumn)) {
            sql.append(" AND ").append(this.buildLogicNormalCondition(logicDeleteColumn, tableInfo));
        }
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        tableInfo.buildTenantCondition(sql, tenantIdArgs, (IDialect)this);
        if (StringUtil.isNotBlank(versionColumn)) {
            Object versionValue = tableInfo.buildColumnSqlArg(entity, versionColumn);
            if (versionValue == null) {
                throw FlexExceptions.wrap(LocalizedFormats.ENTITY_VERSION_NULL, entity);
            }
            sql.append(" AND ").append(this.wrap(versionColumn)).append(" = ").append(versionValue);
        }
        return sql.toString();
    }

    @Override
    public String forUpdateEntityByQuery(TableInfo tableInfo, Object entity, boolean ignoreNulls, QueryWrapper queryWrapper) {
        List<String> endFragments;
        String versionColumn;
        StringBuilder sqlBuilder = new StringBuilder();
        Set<String> updateColumns = tableInfo.obtainUpdateColumns(entity, ignoreNulls, true);
        Map<String, RawValue> rawValueMap = tableInfo.obtainUpdateRawValueMap(entity);
        sqlBuilder.append("UPDATE ").append(this.forHint(CPI.getHint(queryWrapper)));
        sqlBuilder.append(tableInfo.getWrapSchemaAndTableName(this));
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        this.buildJoinSql(sqlBuilder, queryWrapper, queryTables);
        sqlBuilder.append(" SET ");
        StringJoiner stringJoiner = new StringJoiner(", ");
        for (String modifyAttr : updateColumns) {
            if (rawValueMap.containsKey(modifyAttr)) {
                stringJoiner.add(this.wrap(modifyAttr) + " = " + rawValueMap.get(modifyAttr).toSql(this));
                continue;
            }
            stringJoiner.add(this.wrap(modifyAttr) + " = ? ");
        }
        Map<String, String> onUpdateColumns = tableInfo.getOnUpdateColumns();
        if (onUpdateColumns != null && !onUpdateColumns.isEmpty()) {
            onUpdateColumns.forEach((column, value) -> stringJoiner.add(this.wrap((String)column) + " = " + value));
        }
        if (StringUtil.isNotBlank(versionColumn = tableInfo.getVersionColumn())) {
            stringJoiner.add(this.wrap(versionColumn) + " = " + this.wrap(versionColumn) + " + 1 ");
        }
        sqlBuilder.append(stringJoiner);
        this.buildWhereSql(sqlBuilder, queryWrapper, queryTables, false);
        this.buildGroupBySql(sqlBuilder, queryWrapper, queryTables);
        this.buildHavingSql(sqlBuilder, queryWrapper, queryTables);
        this.buildOrderBySql(sqlBuilder, queryWrapper, queryTables);
        Long limitRows = CPI.getLimitRows(queryWrapper);
        Long limitOffset = CPI.getLimitOffset(queryWrapper);
        if (limitRows != null || limitOffset != null) {
            sqlBuilder = this.buildLimitOffsetSql(sqlBuilder, queryWrapper, limitRows, limitOffset);
        }
        if (CollectionUtil.isNotEmpty(endFragments = CPI.getEndFragments(queryWrapper))) {
            for (String endFragment : endFragments) {
                sqlBuilder.append(" ").append(endFragment);
            }
        }
        return sqlBuilder.toString();
    }

    @Override
    public String forSelectOneEntityById(TableInfo tableInfo) {
        StringBuilder sql = new StringBuilder();
        this.buildSelectColumnSql(sql, null, null, null);
        sql.append(" FROM ").append(tableInfo.getWrapSchemaAndTableName(this));
        sql.append(" WHERE ");
        String[] pKeys = tableInfo.getPrimaryColumns();
        for (int i = 0; i < pKeys.length; ++i) {
            if (i > 0) {
                sql.append(" AND ");
            }
            sql.append(this.wrap(pKeys[i])).append(" = ? ");
        }
        String logicDeleteColumn = tableInfo.getLogicDeleteColumnOrSkip();
        if (StringUtil.isNotBlank(logicDeleteColumn)) {
            sql.append(" AND ").append(this.buildLogicNormalCondition(logicDeleteColumn, tableInfo));
        }
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        tableInfo.buildTenantCondition(sql, tenantIdArgs, (IDialect)this);
        return sql.toString();
    }

    @Override
    public String forSelectEntityListByIds(TableInfo tableInfo, Object[] primaryValues) {
        StringBuilder sql = new StringBuilder();
        this.buildSelectColumnSql(sql, null, tableInfo.getDefaultQueryColumn(), null);
        sql.append(" FROM ").append(tableInfo.getWrapSchemaAndTableName(this));
        sql.append(" WHERE ");
        String[] primaryKeys = tableInfo.getPrimaryColumns();
        String logicDeleteColumn = tableInfo.getLogicDeleteColumnOrSkip();
        Object[] tenantIdArgs = tableInfo.buildTenantIdArgs();
        if (StringUtil.isNotBlank(logicDeleteColumn) || ArrayUtil.isNotEmpty(tenantIdArgs)) {
            sql.append("(");
        }
        if (primaryKeys.length > 1) {
            for (int i = 0; i < primaryValues.length / primaryKeys.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append("(");
                for (int j = 0; j < primaryKeys.length; ++j) {
                    if (j > 0) {
                        sql.append(" AND ");
                    }
                    sql.append(this.wrap(primaryKeys[j])).append(" = ? ");
                }
                sql.append(")");
            }
        } else {
            for (int i = 0; i < primaryValues.length; ++i) {
                if (i > 0) {
                    sql.append(" OR ");
                }
                sql.append(this.wrap(primaryKeys[0])).append(" = ? ");
            }
        }
        if (StringUtil.isNotBlank(logicDeleteColumn) || ArrayUtil.isNotEmpty(tenantIdArgs)) {
            sql.append(")");
        }
        if (StringUtil.isNotBlank(logicDeleteColumn)) {
            sql.append(" AND ").append(this.buildLogicNormalCondition(logicDeleteColumn, tableInfo));
        }
        tableInfo.buildTenantCondition(sql, tenantIdArgs, (IDialect)this);
        return sql.toString();
    }

    protected boolean buildJoinSql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables) {
        List<Join> joins = CPI.getJoins(queryWrapper);
        boolean joinSuccess = false;
        if (joins != null && !joins.isEmpty()) {
            for (Join join : joins) {
                if (!join.checkEffective()) continue;
                sqlBuilder.append(join.toSql(queryTables, this));
                joinSuccess = true;
            }
        }
        return joinSuccess;
    }

    protected void buildWhereSql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables, boolean allowNoCondition) {
        QueryCondition whereQueryCondition = CPI.getWhereQueryCondition(queryWrapper);
        if (whereQueryCondition != null) {
            String whereSql = whereQueryCondition.toSql(queryTables, this);
            if (StringUtil.isNotBlank(whereSql)) {
                sqlBuilder.append(" WHERE ").append(whereSql);
            } else if (!allowNoCondition) {
                throw FlexExceptions.wrap(LocalizedFormats.UPDATE_OR_DELETE_NOT_ALLOW, new Object[0]);
            }
        } else if (!allowNoCondition) {
            throw FlexExceptions.wrap(LocalizedFormats.UPDATE_OR_DELETE_NOT_ALLOW, new Object[0]);
        }
    }

    protected void buildGroupBySql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables) {
        List<QueryColumn> groupByColumns = CPI.getGroupByColumns(queryWrapper);
        if (groupByColumns != null && !groupByColumns.isEmpty()) {
            sqlBuilder.append(" GROUP BY ");
            int index = 0;
            for (QueryColumn groupByColumn : groupByColumns) {
                String groupBy = CPI.toConditionSql(groupByColumn, queryTables, this);
                sqlBuilder.append(groupBy);
                if (index != groupByColumns.size() - 1) {
                    sqlBuilder.append(", ");
                }
                ++index;
            }
        }
    }

    protected void buildHavingSql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables) {
        String havingSql;
        QueryCondition havingQueryCondition = CPI.getHavingQueryCondition(queryWrapper);
        if (havingQueryCondition != null && StringUtil.isNotBlank(havingSql = havingQueryCondition.toSql(queryTables, this))) {
            sqlBuilder.append(" HAVING ").append(havingSql);
        }
    }

    protected void buildOrderBySql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, List<QueryTable> queryTables) {
        List<QueryOrderBy> orderBys = CPI.getOrderBys(queryWrapper);
        if (orderBys != null && !orderBys.isEmpty()) {
            sqlBuilder.append(" ORDER BY ");
            int index = 0;
            for (QueryOrderBy orderBy : orderBys) {
                sqlBuilder.append(orderBy.toSql(queryTables, this));
                if (index != orderBys.size() - 1) {
                    sqlBuilder.append(", ");
                }
                ++index;
            }
        }
    }

    protected StringBuilder buildLimitOffsetSql(StringBuilder sqlBuilder, QueryWrapper queryWrapper, Long limitRows, Long limitOffset) {
        return this.limitOffsetProcessor.process(this, sqlBuilder, queryWrapper, limitRows, limitOffset);
    }

    protected String buildLogicNormalCondition(String logicColumn, TableInfo tableInfo) {
        return LogicDeleteManager.getProcessor().buildLogicNormalCondition(logicColumn, tableInfo, this);
    }

    protected String buildLogicDeletedSet(String logicColumn, TableInfo tableInfo) {
        return LogicDeleteManager.getProcessor().buildLogicDeletedSet(logicColumn, tableInfo, this);
    }
}

