/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.field;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.field.FieldQuery;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FieldQueryManager {
    private FieldQueryManager() {
    }

    public static void queryFields(BaseMapper<?> mapper, Collection<?> entities, Map<String, FieldQuery> fieldQueryMap) {
        for (Object entity : entities) {
            if (entity == null) continue;
            String className = ClassUtil.getUsefulClass(entity.getClass()).getName();
            fieldQueryMap.forEach((key, fieldQuery) -> {
                Object value;
                if (!key.startsWith(className + "#")) {
                    return;
                }
                QueryWrapper queryWrapper = fieldQuery.getQueryBuilder().build(entity);
                if (queryWrapper == null) {
                    return;
                }
                Class<?> filedType = fieldQuery.getFieldWrapper().getFieldType();
                if (Collection.class.isAssignableFrom(filedType)) {
                    Class<?> mappingType = fieldQuery.getFieldWrapper().getMappingType();
                    List<?> list = mapper.selectListByQueryAs(queryWrapper, mappingType);
                    value = FieldQueryManager.getCollectionValue(filedType, list);
                    if (!(Number.class.isAssignableFrom(mappingType) && String.class.isAssignableFrom(mappingType) && Map.class.isAssignableFrom(mappingType) || fieldQuery.isPrevent())) {
                        FieldQueryManager.queryFields(mapper, (Collection)value, fieldQueryMap);
                    }
                } else if (Map.class.isAssignableFrom(filedType)) {
                    List<Row> rows = mapper.selectRowsByQuery(queryWrapper);
                    value = rows != null && !rows.isEmpty() && rows.get(0) != null ? FieldQueryManager.getMapValue(filedType, rows.get(0)) : new HashMap();
                } else if (filedType.isArray()) {
                    Class<?> componentType = filedType.getComponentType();
                    List<?> objects = mapper.selectListByQueryAs(queryWrapper, componentType);
                    value = FieldQueryManager.getArrayValue(componentType, objects);
                } else {
                    value = mapper.selectOneByQueryAs(queryWrapper, filedType);
                    if (!fieldQuery.isPrevent()) {
                        FieldQueryManager.queryFields(mapper, Collections.singletonList(value), fieldQueryMap);
                    }
                }
                if (value != null) {
                    fieldQuery.getFieldWrapper().set(value, entity);
                }
            });
        }
    }

    private static Object getCollectionValue(Class<?> fieldType, Collection value) {
        if (value == null) {
            if (fieldType == List.class) {
                return Collections.emptyList();
            }
            if (fieldType == Set.class) {
                return Collections.emptySet();
            }
            return ClassUtil.newInstance(fieldType);
        }
        if (ClassUtil.canInstance(fieldType.getModifiers())) {
            Collection collection = (Collection)ClassUtil.newInstance(fieldType);
            collection.addAll(value);
            return collection;
        }
        if (List.class.isAssignableFrom(fieldType)) {
            return value;
        }
        if (Set.class.isAssignableFrom(fieldType)) {
            return new HashSet(value);
        }
        throw FlexExceptions.wrap("Unsupported collection type: " + fieldType, new Object[0]);
    }

    private static Object getMapValue(Class<?> fieldType, Map value) {
        if (ClassUtil.canInstance(fieldType.getModifiers())) {
            Map map = (Map)ClassUtil.newInstance(fieldType);
            map.putAll(value);
            return map;
        }
        return new HashMap(value);
    }

    private static <T> Object getArrayValue(Class<?> componentType, List<T> list) {
        if (CollectionUtil.isEmpty(list)) {
            return Array.newInstance(componentType, 0);
        }
        Object[] array = (Object[])Array.newInstance(componentType, list.size());
        for (int rows = 0; rows < list.size(); ++rows) {
            array[rows] = list.get(rows);
        }
        return array;
    }
}

