/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.WrapperUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.StringUtil;
import java.util.List;

public class DistinctQueryColumn
extends QueryColumn {
    private List<QueryColumn> queryColumns;

    public DistinctQueryColumn(QueryColumn ... queryColumns) {
        this.queryColumns = CollectionUtil.newArrayList(queryColumns);
    }

    @Override
    public String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        if (CollectionUtil.isEmpty(queryTables)) {
            return "";
        }
        String sql = "DISTINCT " + StringUtil.join(", ", this.queryColumns, queryColumn -> queryColumn.toSelectSql(queryTables, dialect));
        return sql + WrapperUtil.buildColumnAlias(this.alias, dialect);
    }

    @Override
    String toConditionSql(List<QueryTable> queryTables, IDialect dialect) {
        if (CollectionUtil.isEmpty(queryTables)) {
            return "";
        }
        return "DISTINCT " + StringUtil.join(", ", this.queryColumns, queryColumn -> queryColumn.toSelectSql(queryTables, dialect));
    }

    @Override
    public DistinctQueryColumn clone() {
        DistinctQueryColumn clone = (DistinctQueryColumn)super.clone();
        clone.queryColumns = CollectionUtil.cloneArrayList(this.queryColumns);
        return clone;
    }
}

