/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.relation;

import com.mybatisflex.annotation.RelationManyToMany;
import com.mybatisflex.annotation.RelationManyToOne;
import com.mybatisflex.annotation.RelationOneToMany;
import com.mybatisflex.annotation.RelationOneToOne;
import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.FlexConsts;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryMethods;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.relation.AbstractRelation;
import com.mybatisflex.core.relation.ManyToMany;
import com.mybatisflex.core.relation.ManyToOne;
import com.mybatisflex.core.relation.OneToMany;
import com.mybatisflex.core.relation.OneToOne;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.CollectionUtil;
import com.mybatisflex.core.util.LambdaGetter;
import com.mybatisflex.core.util.LambdaUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.util.MapUtil;

public class RelationManager {
    private static Map<Class<?>, List<AbstractRelation>> classRelations = new ConcurrentHashMap();
    private static int defaultQueryDepth = FlexGlobalConfig.getDefaultConfig().getDefaultRelationQueryDepth();
    private static ThreadLocal<Integer> depthThreadLocal = ThreadLocal.withInitial(() -> defaultQueryDepth);
    private static ThreadLocal<Map<String, Object>> extraConditionParams = new ThreadLocal();
    private static ThreadLocal<Set<String>> ignoreRelations = new ThreadLocal();
    private static ThreadLocal<Set<String>> onlyQueryRelations = new ThreadLocal();
    private static ThreadLocal<Boolean> autoClearConfig = ThreadLocal.withInitial(() -> true);

    private RelationManager() {
    }

    public static int getDefaultQueryDepth() {
        return defaultQueryDepth;
    }

    public static void setDefaultQueryDepth(int defaultQueryDepth) {
        RelationManager.defaultQueryDepth = defaultQueryDepth;
    }

    public static void setMaxDepth(int maxDepth) {
        depthThreadLocal.set(maxDepth);
    }

    public static int getMaxDepth() {
        return depthThreadLocal.get();
    }

    public static void clearMaxDepth() {
        extraConditionParams.remove();
    }

    public static void setExtraConditionParams(Map<String, Object> params) {
        extraConditionParams.set(params);
    }

    public static void addExtraConditionParam(String key, Object value) {
        Map<String, Object> params = extraConditionParams.get();
        if (params == null) {
            params = new HashMap<String, Object>();
            extraConditionParams.set(params);
        }
        params.put(key, value);
    }

    public static Map<String, Object> getExtraConditionParams() {
        return extraConditionParams.get();
    }

    public static void clearExtraConditionParams() {
        extraConditionParams.remove();
    }

    public static Set<String> getIgnoreRelations() {
        return ignoreRelations.get();
    }

    public static void setIgnoreRelations(Set<String> ignoreRelations) {
        RelationManager.ignoreRelations.set(ignoreRelations);
    }

    public static <T> void addIgnoreRelations(LambdaGetter<T> ... ignoreRelations) {
        Set<String> relations = RelationManager.ignoreRelations.get();
        if (relations == null) {
            relations = new HashSet<String>();
            RelationManager.setIgnoreRelations(relations);
        }
        for (LambdaGetter<T> lambdaGetter : ignoreRelations) {
            String fieldName = LambdaUtil.getFieldName(lambdaGetter);
            relations.add(fieldName);
        }
    }

    public static void addIgnoreRelations(String ... ignoreRelations) {
        Set<String> relations = RelationManager.ignoreRelations.get();
        if (relations == null) {
            relations = new HashSet<String>();
            RelationManager.setIgnoreRelations(relations);
        }
        relations.addAll(Arrays.asList(ignoreRelations));
    }

    public static void clearIgnoreRelations() {
        ignoreRelations.remove();
    }

    public static Set<String> getQueryRelations() {
        return onlyQueryRelations.get();
    }

    public static void setQueryRelations(Set<String> queryRelations) {
        onlyQueryRelations.set(queryRelations);
    }

    public static <T> void addQueryRelations(LambdaGetter<T> ... queryRelations) {
        Set<String> relations = onlyQueryRelations.get();
        if (relations == null) {
            relations = new HashSet<String>();
            RelationManager.setQueryRelations(relations);
        }
        for (LambdaGetter<T> lambdaGetter : queryRelations) {
            String fieldName = LambdaUtil.getFieldName(lambdaGetter);
            relations.add(fieldName);
        }
    }

    public static void addQueryRelations(String ... queryRelations) {
        Set<String> relations = onlyQueryRelations.get();
        if (relations == null) {
            relations = new HashSet<String>();
            RelationManager.setQueryRelations(relations);
        }
        relations.addAll(Arrays.asList(queryRelations));
    }

    public static void clearQueryRelations() {
        onlyQueryRelations.remove();
    }

    public static void setAutoClearConfig(boolean enable) {
        autoClearConfig.set(enable);
    }

    public static boolean getAutoClearConfig() {
        return autoClearConfig.get();
    }

    public static void clearAutoClearConfig() {
        autoClearConfig.remove();
    }

    static Object[] getExtraConditionParams(List<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return FlexConsts.EMPTY_ARRAY;
        }
        Map<String, Object> paramMap = extraConditionParams.get();
        if (paramMap == null || paramMap.isEmpty()) {
            return new Object[keys.size()];
        }
        Object[] params = new Object[keys.size()];
        for (int i = 0; i < keys.size(); ++i) {
            params[i] = paramMap.get(keys.get(i));
        }
        return params;
    }

    private static List<AbstractRelation> getRelations(Class<?> clazz) {
        return (List)MapUtil.computeIfAbsent(classRelations, clazz, RelationManager::doGetRelations);
    }

    private static List<AbstractRelation> doGetRelations(Class<?> entityClass) {
        List<Field> allFields = ClassUtil.getAllFields(entityClass);
        ArrayList<AbstractRelation> relations = new ArrayList<AbstractRelation>();
        for (Field field : allFields) {
            RelationOneToOne oneToOneAnnotation;
            RelationOneToMany oneToManyAnnotation;
            RelationManyToOne manyToOneAnnotation;
            RelationManyToMany manyToManyAnnotation = field.getAnnotation(RelationManyToMany.class);
            if (manyToManyAnnotation != null) {
                relations.add(new ManyToMany(manyToManyAnnotation, entityClass, field));
            }
            if ((manyToOneAnnotation = field.getAnnotation(RelationManyToOne.class)) != null) {
                relations.add(new ManyToOne(manyToOneAnnotation, entityClass, field));
            }
            if ((oneToManyAnnotation = field.getAnnotation(RelationOneToMany.class)) != null) {
                relations.add(new OneToMany(oneToManyAnnotation, entityClass, field));
            }
            if ((oneToOneAnnotation = field.getAnnotation(RelationOneToOne.class)) == null) continue;
            relations.add(new OneToOne(oneToOneAnnotation, entityClass, field));
        }
        return relations;
    }

    public static <Entity> void queryRelations(BaseMapper<?> mapper, List<Entity> entities) {
        RelationManager.doQueryRelations(mapper, entities, 0, depthThreadLocal.get(), ignoreRelations.get(), onlyQueryRelations.get());
        RelationManager.clearConfigIfNecessary();
    }

    private static void clearConfigIfNecessary() {
        Boolean autoClearEnable = autoClearConfig.get();
        if (autoClearEnable != null && autoClearEnable.booleanValue()) {
            depthThreadLocal.remove();
            extraConditionParams.remove();
            onlyQueryRelations.remove();
            ignoreRelations.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <Entity> void doQueryRelations(BaseMapper<?> mapper, List<Entity> entities, int currentDepth, int maxDepth, Set<String> ignoreRelations, Set<String> queryRelations) {
        if (CollectionUtil.isEmpty(entities)) {
            return;
        }
        if (currentDepth >= maxDepth) {
            return;
        }
        Class<?> entityClass = ClassUtil.getUsefulClass(entities.get(0).getClass());
        List<AbstractRelation> relations = RelationManager.getRelations(entityClass);
        if (relations.isEmpty()) {
            return;
        }
        String currentDsKey = DataSourceKey.get();
        try {
            relations.forEach(relation -> {
                QueryWrapper queryWrapper;
                HashSet<Object> targetValues;
                if (ignoreRelations != null && (ignoreRelations.contains(relation.getSimpleName()) || ignoreRelations.contains(relation.getName()))) {
                    return;
                }
                if (!(queryRelations == null || queryRelations.isEmpty() || queryRelations.contains(relation.getSimpleName()) || queryRelations.contains(relation.getName()))) {
                    return;
                }
                List<Row> mappingRows = null;
                if (relation.isRelationByMiddleTable()) {
                    targetValues = new HashSet();
                    Set<Object> selfFieldValues = relation.getSelfFieldValues(entities);
                    queryWrapper = QueryWrapper.create().select().from(relation.getJoinTable());
                    if (selfFieldValues.size() > 1) {
                        queryWrapper.where((QueryCondition)QueryMethods.column(relation.getJoinSelfColumn(), new Object[0]).in(selfFieldValues));
                    } else {
                        queryWrapper.where(QueryMethods.column(relation.getJoinSelfColumn(), new Object[0]).eq(selfFieldValues.iterator().next()));
                    }
                    mappingRows = mapper.selectListByQueryAs(queryWrapper, Row.class);
                    if (CollectionUtil.isEmpty(mappingRows)) {
                        return;
                    }
                    for (Row mappingData : mappingRows) {
                        Object targetValue = mappingData.getIgnoreCase(relation.getJoinTargetColumn());
                        if (targetValue == null) continue;
                        targetValues.add(targetValue);
                    }
                } else {
                    targetValues = relation.getSelfFieldValues(entities);
                }
                if (CollectionUtil.isEmpty(targetValues)) {
                    return;
                }
                String configDsKey = relation.getDataSource();
                if (StringUtil.isBlank(configDsKey) && currentDsKey != null) {
                    configDsKey = currentDsKey;
                }
                try {
                    List<?> targetObjectList;
                    if (StringUtil.isNotBlank(configDsKey)) {
                        DataSourceKey.use(configDsKey);
                    }
                    if (CollectionUtil.isNotEmpty(targetObjectList = mapper.selectListByQueryAs(queryWrapper = relation.buildQueryWrapper(targetValues), relation.isOnlyQueryValueField() ? relation.getTargetEntityClass() : relation.getMappingType()))) {
                        RelationManager.doQueryRelations(mapper, targetObjectList, currentDepth + 1, maxDepth, ignoreRelations, queryRelations);
                        relation.join(entities, targetObjectList, mappingRows);
                    }
                }
                finally {
                    if (StringUtil.isNotBlank(configDsKey)) {
                        DataSourceKey.clear();
                    }
                }
            });
        }
        finally {
            if (currentDsKey != null) {
                DataSourceKey.use(currentDsKey);
            }
        }
    }
}

