/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.keygen;

import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.keygen.IKeyGenerator;
import com.mybatisflex.core.keygen.KeyGeneratorFactory;
import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.row.RowKey;
import java.sql.Statement;
import java.util.Map;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.keygen.KeyGenerator;
import org.apache.ibatis.mapping.MappedStatement;

public class RowCustomKeyGenerator
implements KeyGenerator {
    protected RowKey rowKey;
    protected IKeyGenerator keyGenerator;

    public RowCustomKeyGenerator(RowKey rowKey) {
        this.rowKey = rowKey;
        this.keyGenerator = KeyGeneratorFactory.getKeyGenerator(rowKey.getValue());
        this.ensuresKeyGeneratorNotNull();
    }

    private void ensuresKeyGeneratorNotNull() {
        if (this.keyGenerator == null) {
            throw FlexExceptions.wrap("The name of \"%s\" key generator not exist.", this.rowKey.getValue());
        }
    }

    public void processBefore(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
        Row row = (Row)((Map)parameter).get("$$row");
        try {
            Object existId = row.get(this.rowKey.getKeyColumn());
            if (existId != null) {
                return;
            }
            Object generateId = this.keyGenerator.generate(row, this.rowKey.getKeyColumn());
            row.put(this.rowKey.getKeyColumn(), generateId);
        }
        catch (Exception e) {
            throw FlexExceptions.wrap(e);
        }
    }

    public void processAfter(Executor executor, MappedStatement ms, Statement stmt, Object parameter) {
    }
}

