/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.exception.FlexExceptions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.util.MapUtil;

public class Mappers {
    private static final Map<Class<?>, Object> MAPPER_OBJECTS = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> ENTITY_MAPPER_MAP = new ConcurrentHashMap();

    private Mappers() {
    }

    static void addMapping(Class<?> entityClass, Class<?> mapperClass) {
        ENTITY_MAPPER_MAP.put(entityClass, mapperClass);
    }

    public static <E> BaseMapper<E> ofEntityClass(Class<E> entityClass) {
        Class<?> mapperClass = ENTITY_MAPPER_MAP.get(entityClass);
        if (mapperClass == null) {
            throw FlexExceptions.wrap("Can not find MapperClass by entity: " + entityClass.getName(), new Object[0]);
        }
        return (BaseMapper)Mappers.ofMapperClass(mapperClass);
    }

    public static <M> M ofMapperClass(Class<M> mapperClass) {
        Object mapperObject = MapUtil.computeIfAbsent(MAPPER_OBJECTS, mapperClass, clazz -> Proxy.newProxyInstance(mapperClass.getClassLoader(), new Class[]{mapperClass}, (InvocationHandler)new MapperHandler(mapperClass)));
        return (M)mapperObject;
    }

    private static class MapperHandler
    implements InvocationHandler {
        private final Class<?> mapperClass;
        private final ExecutorType executorType;
        private final SqlSessionFactory sqlSessionFactory;

        public MapperHandler(Class<?> mapperClass) {
            this.mapperClass = mapperClass;
            this.executorType = FlexGlobalConfig.getDefaultConfig().getConfiguration().getDefaultExecutorType();
            this.sqlSessionFactory = FlexGlobalConfig.getDefaultConfig().getSqlSessionFactory();
        }

        private SqlSession openSession() {
            return this.sqlSessionFactory.openSession(this.executorType, true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try (SqlSession sqlSession = this.openSession();){
                Object mapper = sqlSession.getMapper(this.mapperClass);
                Object object = method.invoke(mapper, args);
                return object;
            }
            catch (Throwable throwable) {
                throw ExceptionUtil.unwrapThrowable((Throwable)throwable);
            }
        }
    }
}

