/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.dialect.IDialect;
import com.mybatisflex.core.exception.FlexExceptions;
import com.mybatisflex.core.query.Brackets;
import com.mybatisflex.core.query.CloneSupport;
import com.mybatisflex.core.query.OperatorQueryCondition;
import com.mybatisflex.core.query.OperatorSelectCondition;
import com.mybatisflex.core.query.QueryColumn;
import com.mybatisflex.core.query.QueryCondition;
import com.mybatisflex.core.query.QueryTable;
import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.SelectQueryTable;
import com.mybatisflex.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class Join
implements CloneSupport<Join> {
    private static final long serialVersionUID = 1L;
    protected final String type;
    protected QueryTable queryTable;
    protected QueryCondition on;
    protected boolean effective;

    public Join(String type, QueryTable table, boolean when) {
        this.type = type;
        this.queryTable = table;
        this.effective = when;
    }

    public Join(String type, QueryWrapper queryWrapper, boolean when) {
        this.type = type;
        this.queryTable = new SelectQueryTable(queryWrapper);
        this.effective = when;
    }

    QueryTable getQueryTable() {
        return this.queryTable;
    }

    public void on(QueryCondition condition) {
        this.replaceConditionColumn(condition);
        this.on = condition;
    }

    private void replaceConditionColumn(QueryCondition condition) {
        if (condition != null) {
            if (condition.checkEffective() && condition.column != null) {
                QueryTable table = condition.column.getTable();
                if (this.queryTable.isSameTable(table)) {
                    QueryColumn newColumn = condition.column.clone();
                    newColumn.table.alias = this.queryTable.alias;
                    condition.column = newColumn;
                }
            } else if (condition instanceof Brackets) {
                this.replaceConditionColumn(((Brackets)condition).getChildCondition());
            } else if (condition instanceof OperatorQueryCondition) {
                this.replaceConditionColumn(((OperatorQueryCondition)condition).getChildCondition());
            } else if (condition instanceof OperatorSelectCondition) {
                QueryWrapper qw = ((OperatorSelectCondition)condition).getQueryWrapper();
                this.replaceConditionColumn(qw.whereQueryCondition);
            }
            this.replaceConditionColumn(condition.next);
        }
    }

    QueryCondition getOnCondition() {
        return this.on;
    }

    public boolean checkEffective() {
        return this.effective;
    }

    public void when(boolean when) {
        this.effective = when;
    }

    public void when(Supplier<Boolean> fn) {
        this.effective = fn.get();
    }

    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder(this.type);
        sql.append(this.queryTable.toSql(dialect));
        ArrayList<QueryTable> newQueryTables = new ArrayList<QueryTable>(queryTables);
        newQueryTables.add(this.queryTable);
        sql.append(" ON ").append(this.on.toSql(newQueryTables, dialect));
        return sql.toString();
    }

    @Override
    public Join clone() {
        try {
            Join clone = (Join)super.clone();
            clone.queryTable = ObjectUtil.clone(this.queryTable);
            clone.on = ObjectUtil.clone(this.on);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw FlexExceptions.wrap(e);
        }
    }
}

