/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.table;

import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.mask.CompositeMaskTypeHandler;
import com.mybatisflex.core.mask.MaskTypeHandler;
import com.mybatisflex.core.util.ArrayUtil;
import com.mybatisflex.core.util.StringUtil;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public class ColumnInfo {
    private static final Class<?>[] needGetTypeHandlerTypes = new Class[]{java.util.Date.class, Date.class, Time.class, Timestamp.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, OffsetDateTime.class, OffsetTime.class, ZonedDateTime.class, Year.class, Month.class, YearMonth.class, JapaneseDate.class, byte[].class, Byte[].class, Byte.class};
    protected String column;
    protected String[] alias;
    protected String property;
    protected Class<?> propertyType;
    protected JdbcType jdbcType;
    protected TypeHandler<?> typeHandler;
    protected TypeHandler<?> buildTypeHandler;
    protected String maskType;
    protected boolean ignore;

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String[] getAlias() {
        return this.alias;
    }

    public void setAlias(String[] alias) {
        this.alias = alias;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Class<?> getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(Class<?> propertyType) {
        this.propertyType = propertyType;
    }

    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
    }

    public TypeHandler<?> buildTypeHandler(Configuration configuration) {
        if (this.buildTypeHandler != null) {
            return this.buildTypeHandler;
        }
        if (StringUtil.isNotBlank(this.maskType)) {
            this.buildTypeHandler = this.typeHandler != null ? new CompositeMaskTypeHandler(this.maskType, this.typeHandler) : new MaskTypeHandler(this.maskType);
        } else if (this.typeHandler != null) {
            this.buildTypeHandler = this.typeHandler;
        } else if (this.propertyType.isEnum() || ArrayUtil.contains(needGetTypeHandlerTypes, this.propertyType)) {
            if (configuration == null) {
                configuration = FlexGlobalConfig.getDefaultConfig().getConfiguration();
            }
            if (configuration != null) {
                this.buildTypeHandler = configuration.getTypeHandlerRegistry().getTypeHandler(this.propertyType);
            }
        }
        return this.buildTypeHandler;
    }

    public void setTypeHandler(TypeHandler<?> typeHandler) {
        this.typeHandler = typeHandler;
    }

    public String getMaskType() {
        return this.maskType;
    }

    public void setMaskType(String maskType) {
        this.maskType = maskType;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }
}

