/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.mybatis.binding;

import com.mybatisflex.annotation.UseDataSource;
import com.mybatisflex.core.FlexGlobalConfig;
import com.mybatisflex.core.datasource.DataSourceKey;
import com.mybatisflex.core.datasource.FlexDataSource;
import com.mybatisflex.core.dialect.DbType;
import com.mybatisflex.core.dialect.DialectFactory;
import com.mybatisflex.core.mybatis.FlexConfiguration;
import com.mybatisflex.core.mybatis.binding.MybatisMapperProxy;
import com.mybatisflex.core.row.RowMapper;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.MapUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.session.SqlSession;

public class FlexMapperProxy<T>
extends MybatisMapperProxy<T> {
    private static final String NULL_KEY = "@NK";
    private static final Map<Method, String> methodDsKeyCache = new ConcurrentHashMap<Method, String>();
    private final FlexDataSource dataSource;

    public FlexMapperProxy(SqlSession sqlSession, Class<T> mapperInterface, Map<Method, MybatisMapperProxy.MapperMethodInvoker> methodCache, FlexConfiguration configuration) {
        super(sqlSession, mapperInterface, methodCache);
        this.dataSource = (FlexDataSource)configuration.getEnvironment().getDataSource();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (Object.class.equals(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        boolean needClearDsKey = false;
        boolean needClearDbType = false;
        try {
            DbType dbType;
            String shardingDataSourceKey;
            String configDataSourceKey;
            String dataSourceKey = DataSourceKey.get();
            if (StringUtil.isBlank(dataSourceKey) && StringUtil.isNotBlank(configDataSourceKey = FlexMapperProxy.getConfigDataSourceKey(method, proxy))) {
                dataSourceKey = configDataSourceKey;
                DataSourceKey.use(dataSourceKey);
                needClearDsKey = true;
            }
            if ((shardingDataSourceKey = DataSourceKey.getByShardingStrategy(dataSourceKey, proxy, method, args)) != null && !shardingDataSourceKey.equals(dataSourceKey)) {
                DataSourceKey.use(shardingDataSourceKey);
                needClearDsKey = true;
            }
            if ((dbType = DialectFactory.getHintDbType()) == null) {
                if (shardingDataSourceKey != null && this.dataSource != null) {
                    dbType = this.dataSource.getDbType(shardingDataSourceKey);
                }
                if (dbType == null && dataSourceKey != null && this.dataSource != null) {
                    dbType = this.dataSource.getDbType(dataSourceKey);
                }
                if (dbType == null) {
                    dbType = DialectFactory.getGlobalDbType();
                }
                if (dbType == null) {
                    dbType = FlexGlobalConfig.getDefaultConfig().getDbType();
                }
                DialectFactory.setHintDbType(dbType);
                needClearDbType = true;
            }
            Object object = this.cachedInvoker(method).invoke(proxy, method, args, this.sqlSession);
            return object;
        }
        catch (Throwable e) {
            throw ExceptionUtil.unwrapThrowable((Throwable)e);
        }
        finally {
            if (needClearDbType) {
                DialectFactory.clearHintDbType();
            }
            if (needClearDsKey) {
                DataSourceKey.clear();
            }
        }
    }

    private static String getConfigDataSourceKey(Method method, Object proxy) {
        String result = MapUtil.computeIfAbsent(methodDsKeyCache, method, method1 -> {
            String dataSourceKey;
            TableInfo tableInfo;
            Class<?>[] interfaces;
            UseDataSource useDataSource = method1.getAnnotation(UseDataSource.class);
            if (useDataSource != null && StringUtil.isNotBlank(useDataSource.value())) {
                return useDataSource.value();
            }
            for (Class<?> anInterface : interfaces = proxy.getClass().getInterfaces()) {
                UseDataSource annotation = anInterface.getAnnotation(UseDataSource.class);
                if (annotation == null) continue;
                return annotation.value();
            }
            if (interfaces[0] != RowMapper.class && (tableInfo = TableInfoFactory.ofMapperClass(interfaces[0])) != null && StringUtil.isNotBlank(dataSourceKey = tableInfo.getDataSource())) {
                return dataSourceKey;
            }
            return NULL_KEY;
        });
        return NULL_KEY.equals(result) ? null : result;
    }
}

