/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.row;

import com.mybatisflex.core.row.Row;
import com.mybatisflex.core.table.TableInfo;
import com.mybatisflex.core.table.TableInfoFactory;
import com.mybatisflex.core.util.ClassUtil;
import com.mybatisflex.core.util.ConvertUtil;
import com.mybatisflex.core.util.MapUtil;
import com.mybatisflex.core.util.StringUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class RowUtil {
    static final String INDEX_SEPARATOR = "$";
    private static final Map<Class<?>, Map<String, Method>> classSettersCache = new ConcurrentHashMap();

    private RowUtil() {
    }

    public static <T> T toObject(Row row, Class<T> objectClass) {
        return RowUtil.toObject(row, objectClass, 0);
    }

    public static <T> T toObject(Row row, Class<T> objectClass, int index) {
        Object instance = ClassUtil.newInstance(objectClass);
        Map<String, Method> classSetters = RowUtil.getSetterMethods(objectClass);
        Set rowKeys = row.keySet();
        classSetters.forEach((property, setter) -> {
            block7: {
                try {
                    if (index <= 0) {
                        for (String rowKey : rowKeys) {
                            if (!property.equalsIgnoreCase(rowKey)) continue;
                            Object rowValue = row.get(rowKey);
                            Object value = ConvertUtil.convert(rowValue, setter.getParameterTypes()[0], true);
                            setter.invoke(instance, value);
                        }
                        break block7;
                    }
                    for (int i = index; i >= 0; --i) {
                        String newProperty = i <= 0 ? property : property + INDEX_SEPARATOR + i;
                        boolean fillValue = false;
                        for (String rowKey : rowKeys) {
                            if (!newProperty.equalsIgnoreCase(rowKey)) continue;
                            Object rowValue = row.get(rowKey);
                            Object value = ConvertUtil.convert(rowValue, setter.getParameterTypes()[0], true);
                            setter.invoke(instance, value);
                            fillValue = true;
                            break;
                        }
                        if (!fillValue) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Can not invoke method: " + setter);
                }
            }
        });
        return instance;
    }

    public static <T> List<T> toObjectList(List<Row> rows, Class<T> objectClass) {
        return RowUtil.toObjectList(rows, objectClass, 0);
    }

    public static <T> List<T> toObjectList(List<Row> rows, Class<T> objectClass, int index) {
        if (rows == null || rows.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> objectList = new ArrayList<T>();
        for (Row row : rows) {
            objectList.add(RowUtil.toObject(row, objectClass, index));
        }
        return objectList;
    }

    public static <T> T toEntity(Row row, Class<T> entityClass) {
        return RowUtil.toEntity(row, entityClass, 0);
    }

    public static <T> T toEntity(Row row, Class<T> entityClass, int index) {
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        return tableInfo.newInstanceByRow(row, index);
    }

    public static <T> List<T> toEntityList(List<Row> rows, Class<T> entityClass) {
        return RowUtil.toEntityList(rows, entityClass, 0);
    }

    public static <T> List<T> toEntityList(List<Row> rows, Class<T> entityClass, int index) {
        if (rows == null || rows.isEmpty()) {
            return Collections.emptyList();
        }
        TableInfo tableInfo = TableInfoFactory.ofEntityClass(entityClass);
        ArrayList entityList = new ArrayList();
        for (Row row : rows) {
            Object entity = tableInfo.newInstanceByRow(row, index);
            entityList.add(entity);
        }
        return entityList;
    }

    public static void registerMapping(Class<?> clazz, Map<String, Method> columnSetterMapping) {
        classSettersCache.put(clazz, columnSetterMapping);
    }

    public static void printPretty(Row row) {
        if (row == null) {
            return;
        }
        RowUtil.printPretty(Collections.singletonList(row));
    }

    public static void printPretty(List<Row> rows) {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        Row firstRow = rows.get(0);
        ArrayList textConsoleLengthList = new ArrayList();
        StringBuilder sb = new StringBuilder("\nTotal Count: " + rows.size() + "\n");
        Set keys = firstRow.keySet();
        keys.forEach(s -> {
            String sa = "|" + s + "     ";
            sb.append(sa);
            textConsoleLengthList.add(RowUtil.calcTextConsoleLength(sa));
        });
        sb.append("|\n");
        rows.forEach(row -> {
            int i = 0;
            for (String key : keys) {
                sb.append(RowUtil.getColString(row.get(key), (Integer)textConsoleLengthList.get(i)));
                ++i;
            }
            sb.append("|\n");
        });
        System.out.println(sb);
    }

    private static String getColString(Object o, int len) {
        String v = "|" + o;
        while (RowUtil.calcTextConsoleLength(v) < len) {
            v = v + " ";
        }
        while (RowUtil.calcTextConsoleLength(v) > len) {
            v = v.substring(0, v.length() - 5) + "... ";
        }
        return v;
    }

    private static int calcTextConsoleLength(String s) {
        char[] chars;
        int result = 0;
        for (char c : chars = s.toCharArray()) {
            if (RowUtil.isCJK(c)) {
                result += 3;
                continue;
            }
            result += 2;
        }
        return result % 2 != 0 ? result + 1 : result;
    }

    private static boolean isCJK(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    private static Map<String, Method> getSetterMethods(Class<?> aClass) {
        return MapUtil.computeIfAbsent(classSettersCache, aClass, aClass1 -> {
            HashMap<String, Method> columnSetterMapping = new HashMap<String, Method>();
            List<Method> setters = ClassUtil.getAllMethods(aClass1, method -> method.getName().startsWith("set") && method.getParameterCount() == 1 && Modifier.isPublic(method.getModifiers()));
            for (Method setter : setters) {
                String column = setter.getName().substring(3);
                columnSetterMapping.put(column, setter);
                columnSetterMapping.put(StringUtil.camelToUnderline(column), setter);
                columnSetterMapping.put(StringUtil.underlineToCamel(column), setter);
            }
            return columnSetterMapping;
        });
    }
}

