/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.datasource;

import com.mybatisflex.core.datasource.DataSourceManager;
import java.lang.reflect.Method;
import java.util.function.Supplier;

public class DataSourceKey {
    private static ThreadLocal<String> annotationKeyThreadLocal = new ThreadLocal();
    private static ThreadLocal<String> manualKeyThreadLocal = new ThreadLocal();

    private DataSourceKey() {
    }

    public static void use(String dataSourceKey) {
        manualKeyThreadLocal.set(dataSourceKey.trim());
    }

    public static void useWithAnnotation(String dataSourceKey) {
        annotationKeyThreadLocal.set(dataSourceKey.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T use(String dataSourceKey, Supplier<T> supplier) {
        String prevKey = manualKeyThreadLocal.get();
        try {
            manualKeyThreadLocal.set(dataSourceKey);
            T t = supplier.get();
            return t;
        }
        finally {
            if (prevKey != null) {
                manualKeyThreadLocal.set(prevKey);
            } else {
                DataSourceKey.clear();
            }
        }
    }

    public static void use(String dataSourceKey, Runnable runnable) {
        String prevKey = manualKeyThreadLocal.get();
        try {
            manualKeyThreadLocal.set(dataSourceKey);
            runnable.run();
        }
        finally {
            if (prevKey != null) {
                manualKeyThreadLocal.set(prevKey);
            } else {
                DataSourceKey.clear();
            }
        }
    }

    public static void clear() {
        annotationKeyThreadLocal.remove();
        manualKeyThreadLocal.remove();
    }

    public static String getByAnnotation() {
        return annotationKeyThreadLocal.get();
    }

    public static String getByManual() {
        return manualKeyThreadLocal.get();
    }

    public static String get() {
        String key = manualKeyThreadLocal.get();
        return key != null ? key : annotationKeyThreadLocal.get();
    }

    public static void setAnnotationKeyThreadLocal(ThreadLocal<String> annotationKeyThreadLocal) {
        DataSourceKey.annotationKeyThreadLocal = annotationKeyThreadLocal;
    }

    public static void setManualKeyThreadLocal(ThreadLocal<String> manualKeyThreadLocal) {
        DataSourceKey.manualKeyThreadLocal = manualKeyThreadLocal;
    }

    public static String getShardingDsKey(String dataSource, Object mapper, Method method, Object[] args) {
        String shardingDsKey = DataSourceManager.getShardingDsKey(dataSource, mapper, method, args);
        return shardingDsKey != null ? shardingDsKey : dataSource;
    }
}

