/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.keygen.impl;

import com.mybatisflex.core.keygen.IKeyGenerator;
import java.util.concurrent.ThreadLocalRandom;

public class ULIDKeyGenerator
implements IKeyGenerator {
    private static final char[] ENCODING_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final long TIMESTAMP_OVERFLOW_MASK = -281474976710656L;
    private static final ThreadLocal<StringBuilder> THREAD_LOCAL_BUILDER = ThreadLocal.withInitial(() -> new StringBuilder(26));
    private long lastTimestamp = 0L;
    private long lastRandom = 0L;

    @Override
    public Object generate(Object entity, String keyColumn) {
        return this.nextId();
    }

    public String nextId() {
        return this.generateULID(System.currentTimeMillis()).toLowerCase();
    }

    public synchronized String nextMonotonicId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp > this.lastTimestamp) {
            this.lastTimestamp = timestamp;
            this.lastRandom = ThreadLocalRandom.current().nextLong();
        } else {
            ++this.lastRandom;
            if (this.lastRandom == 0L) {
                this.lastTimestamp = timestamp = this.waitNextMillis(this.lastTimestamp);
                this.lastRandom = ThreadLocalRandom.current().nextLong();
            }
        }
        return this.generateULID(this.lastTimestamp, this.lastRandom).toLowerCase();
    }

    private String generateULID(long timestamp) {
        return this.generateULID(timestamp, ThreadLocalRandom.current().nextLong());
    }

    private String generateULID(long timestamp, long random) {
        ULIDKeyGenerator.checkTimestamp(timestamp);
        StringBuilder builder = THREAD_LOCAL_BUILDER.get();
        builder.setLength(0);
        ULIDKeyGenerator.appendCrockford(builder, timestamp, 10);
        ULIDKeyGenerator.appendCrockford(builder, random, 16);
        return builder.toString();
    }

    private long waitNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }

    private static void appendCrockford(StringBuilder builder, long value, int count) {
        for (int i = (count - 1) * 5; i >= 0; i -= 5) {
            int index = (int)(value >>> i & 0x1FL);
            builder.append(ENCODING_CHARS[index]);
        }
    }

    private static void checkTimestamp(long timestamp) {
        if ((timestamp & 0xFFFF000000000000L) != 0L) {
            throw new IllegalArgumentException("ULID does not support timestamps after +10889-08-02T05:31:50.655Z!");
        }
    }
}

