/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.core.query;

import com.mybatisflex.core.query.QueryWrapper;
import com.mybatisflex.core.query.With;
import com.mybatisflex.core.query.WithItem;
import com.mybatisflex.core.query.WithSelectDetail;
import com.mybatisflex.core.query.WithStringDetail;
import com.mybatisflex.core.query.WithValuesDetail;
import com.mybatisflex.core.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class WithBuilder<Wrapper extends QueryWrapper> {
    private Wrapper queryWrapper;
    private With with;
    private String name;
    private List<String> params;

    public WithBuilder() {
    }

    public WithBuilder(Wrapper queryWrapper, With with, String name) {
        this.queryWrapper = queryWrapper;
        this.with = with;
        this.name = name;
    }

    public WithBuilder(Wrapper queryWrapper, With with, String name, List<String> params) {
        this.queryWrapper = queryWrapper;
        this.with = with;
        this.name = name;
        this.params = params;
    }

    public Wrapper asSelect(QueryWrapper newWrapper) {
        WithItem withItem = new WithItem(this.name, this.params);
        withItem.setWithDetail(new WithSelectDetail(newWrapper));
        this.with.addWithItem(withItem);
        return this.queryWrapper;
    }

    public Wrapper asValues(Object[] values, QueryWrapper newWrapper) {
        WithItem withItem = new WithItem(this.name, this.params);
        withItem.setWithDetail(new WithValuesDetail(Arrays.asList(values), newWrapper));
        this.with.addWithItem(withItem);
        return this.queryWrapper;
    }

    public Wrapper asValues(Collection values, QueryWrapper newWrapper) {
        WithItem withItem = new WithItem(this.name, this.params);
        withItem.setWithDetail(new WithValuesDetail(CollectionUtil.toList(values), newWrapper));
        this.with.addWithItem(withItem);
        return this.queryWrapper;
    }

    public Wrapper asRaw(String rawSQL, Object ... params) {
        WithItem withItem = new WithItem(this.name, this.params);
        withItem.setWithDetail(new WithStringDetail(rawSQL, params));
        this.with.addWithItem(withItem);
        return this.queryWrapper;
    }
}

