/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.header;

import com.mycila.maven.plugin.license.header.HeaderDefinition;
import com.mycila.maven.plugin.license.util.FileContent;
import com.mycila.maven.plugin.license.util.StringUtils;

public final class HeaderParser {
    private final int beginPosition;
    private final int endPosition;
    private final boolean existingHeader;
    private final FileContent fileContent;
    private final String[] keywords;
    private HeaderDefinition headerDefinition;
    private String line;

    public HeaderParser(FileContent fileContent, HeaderDefinition headerDefinition, String[] keywords) {
        if (fileContent == null) {
            throw new IllegalArgumentException("Cannot create a header parser for null file content");
        }
        if (headerDefinition == null) {
            throw new IllegalArgumentException("Cannot work on file header if the header definition is null");
        }
        this.keywords = (String[])keywords.clone();
        this.headerDefinition = headerDefinition;
        this.fileContent = fileContent;
        this.beginPosition = this.findBeginPosition();
        this.existingHeader = this.hasHeader();
        this.endPosition = this.existingHeader ? this.findEndPosition() : -1;
    }

    public int getBeginPosition() {
        return this.beginPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public boolean gotAnyHeader() {
        return this.existingHeader;
    }

    public FileContent getFileContent() {
        return this.fileContent;
    }

    public HeaderDefinition getHeaderDefinition() {
        return this.headerDefinition;
    }

    /*
     * Unable to fully structure code
     */
    private int findBeginPosition() {
        beginPos = 0;
        this.line = this.fileContent.nextLine();
        if (this.headerDefinition.getSkipLinePattern() != null) ** GOTO lbl7
        return beginPos;
lbl-1000:
        // 1 sources

        {
            beginPos = this.fileContent.getPosition();
            this.line = this.fileContent.nextLine();
lbl7:
            // 2 sources

            ** while (this.line != null && !this.headerDefinition.isSkipLine((String)this.line))
        }
lbl8:
        // 2 sources

        while (this.line != null && this.headerDefinition.isSkipLine(this.line)) {
            beginPos = this.fileContent.getPosition();
            this.line = this.fileContent.nextLine();
        }
        if (this.line == null) {
            beginPos = 0;
            this.fileContent.reset();
            this.line = this.fileContent.nextLine();
        }
        return beginPos;
    }

    private boolean hasHeader() {
        while (this.line != null && "".equals(this.line.trim())) {
            this.line = this.fileContent.nextLine();
        }
        boolean gotHeader = false;
        if (this.headerDefinition.isFirstHeaderLine(this.line)) {
            if (this.headerDefinition.allowBlankLines()) {
                do {
                    this.line = this.fileContent.nextLine();
                } while (this.line != null && "".equals(this.line.trim()));
            }
            if (this.line == null) {
                return false;
            }
            StringBuilder inPlaceHeader = new StringBuilder();
            String before = StringUtils.rtrim(this.headerDefinition.getBeforeEachLine());
            if ("".equals(before) && !this.headerDefinition.isMultiLine()) {
                before = this.headerDefinition.getBeforeEachLine();
            }
            boolean foundEnd = false;
            do {
                inPlaceHeader.append(this.line.toLowerCase());
                this.line = this.fileContent.nextLine();
                if (!this.headerDefinition.isMultiLine() || !this.headerDefinition.isLastHeaderLine(this.line)) continue;
                foundEnd = true;
                break;
            } while (this.line != null && this.line.startsWith(before));
            if (this.headerDefinition.allowBlankLines()) {
                do {
                    this.line = this.fileContent.nextLine();
                } while (this.line != null && "".equals(this.line.trim()));
            }
            if (this.headerDefinition.allowBlankLines() || !foundEnd) {
                this.fileContent.rewind();
            }
            if (!this.headerDefinition.isMultiLine()) {
                int pos = this.fileContent.getPosition();
                while (this.line != null && !this.headerDefinition.isLastHeaderLine(this.line) && (this.headerDefinition.allowBlankLines() || !"".equals(this.line.trim())) && this.line.startsWith(before)) {
                    this.line = this.fileContent.nextLine();
                }
                if (this.line == null) {
                    this.fileContent.resetTo(pos);
                }
            }
            gotHeader = true;
            String[] stringArray = this.keywords;
            int n = this.keywords.length;
            int n2 = 0;
            while (n2 < n) {
                String keyword = stringArray[n2];
                if (inPlaceHeader.indexOf(keyword.toLowerCase()) == -1) {
                    gotHeader = false;
                    break;
                }
                ++n2;
            }
        }
        return gotHeader;
    }

    private int findEndPosition() {
        int end = this.fileContent.getPosition();
        this.line = this.fileContent.nextLine();
        if (this.line != null && "".equals(this.line.trim())) {
            end = this.fileContent.getPosition();
        }
        return end;
    }
}

