/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.document;

import com.mycila.maven.plugin.license.document.DocumentPropertiesLoader;
import com.mycila.maven.plugin.license.document.PropertyPlaceholderResolver;
import com.mycila.maven.plugin.license.header.Header;
import com.mycila.maven.plugin.license.header.HeaderDefinition;
import com.mycila.maven.plugin.license.header.HeaderParser;
import com.mycila.maven.plugin.license.header.HeaderType;
import com.mycila.maven.plugin.license.util.FileContent;
import com.mycila.maven.plugin.license.util.FileUtils;
import java.io.File;
import java.io.IOException;

public final class Document {
    private final File file;
    private final HeaderDefinition headerDefinition;
    private final String encoding;
    private final String[] keywords;
    private final DocumentPropertiesLoader documentPropertiesLoader;
    private final PropertyPlaceholderResolver placeholderResolver = new PropertyPlaceholderResolver();
    private HeaderParser parser;

    public Document(File file, HeaderDefinition headerDefinition, String encoding, String[] keywords, DocumentPropertiesLoader documentPropertiesLoader) {
        this.keywords = (String[])keywords.clone();
        this.file = file;
        this.headerDefinition = headerDefinition;
        this.encoding = encoding;
        this.documentPropertiesLoader = documentPropertiesLoader;
    }

    public HeaderDefinition getHeaderDefinition() {
        return this.headerDefinition;
    }

    public File getFile() {
        return this.file;
    }

    public String getFilePath() {
        return this.getFile().getPath().replace('\\', '/');
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isNotSupported() {
        return this.headerDefinition == null || HeaderType.UNKNOWN.getDefinition().getType().equals(this.headerDefinition.getType());
    }

    public boolean hasHeader(Header header, boolean strictCheck) {
        if (!strictCheck) {
            try {
                String fileHeader = FileUtils.readFirstLines(this.file, header.getLineCount() + 10, this.encoding);
                String fileHeaderOneLine = FileUtils.remove(fileHeader, this.headerDefinition.getFirstLine().trim(), this.headerDefinition.getEndLine().trim(), this.headerDefinition.getBeforeEachLine().trim(), "\n", "\r", "\t", " ");
                String headerOnOnelIne = this.mergeProperties(header.asOneLineString());
                return fileHeaderOneLine.contains(FileUtils.remove(headerOnOnelIne, this.headerDefinition.getFirstLine().trim(), this.headerDefinition.getEndLine().trim(), this.headerDefinition.getBeforeEachLine().trim()));
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot read file " + this.getFilePath() + ". Cause: " + e.getMessage(), e);
            }
        }
        try {
            return header.isMatchForText(this, this.headerDefinition, true, this.encoding);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read file " + this.getFilePath() + ". Cause: " + e.getMessage(), e);
        }
    }

    public void updateHeader(Header header) {
        String headerStr = header.applyDefinitionAndSections(this.parser.getHeaderDefinition(), this.parser.getFileContent().isUnix());
        this.parser.getFileContent().insert(this.parser.getBeginPosition(), this.mergeProperties(headerStr));
    }

    public String mergeProperties(String str) {
        return this.placeholderResolver.replacePlaceholders(str, this.documentPropertiesLoader.load(this));
    }

    public void save() {
        this.saveTo(this.file);
    }

    public void saveTo(File dest) {
        if (this.parser != null) {
            try {
                FileUtils.write(dest, this.parser.getFileContent().getContent(), this.encoding);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot write new header in file " + this.getFilePath() + ". Cause: " + e.getMessage(), e);
            }
        }
    }

    public String getContent() {
        return this.parser == null ? "" : this.parser.getFileContent().getContent();
    }

    public void removeHeader() {
        if (this.headerDetected()) {
            this.parser.getFileContent().delete(this.parser.getBeginPosition(), this.parser.getEndPosition());
        }
    }

    public boolean is(Header header) {
        try {
            return header.getLocation().isFromUrl(this.file.toURI().toURL());
        }
        catch (Exception e) {
            throw new IllegalStateException("Error comparing document " + this.file + " with file " + this.file + ". Cause: " + e.getMessage(), e);
        }
    }

    public void parseHeader() {
        if (this.parser == null) {
            this.parser = new HeaderParser(new FileContent(this.file, this.encoding), this.headerDefinition, this.keywords);
        }
    }

    public boolean headerDetected() {
        return this.parser.gotAnyHeader();
    }

    public String toString() {
        return "Document " + this.getFilePath();
    }
}

