/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.xmltool;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

final class CachedEntityResolver
implements EntityResolver,
EntityResolver2 {
    static final CachedEntityResolver instance = new CachedEntityResolver();
    private Map<String, String[]> cache = new ConcurrentHashMap<String, String[]>();

    private CachedEntityResolver() {
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        return this.resolveEntity(publicId, systemId);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String[] objs = this.cache.get(systemId);
        if (objs == null) {
            objs = this.read(systemId);
            this.cache.put(systemId, objs);
        }
        InputSource is = new InputSource(new StringReader(objs[0]));
        is.setEncoding(objs[1]);
        return is;
    }

    private String[] read(String url) {
        try {
            int c;
            URL u = new URL(url);
            URLConnection con = u.openConnection();
            con.setConnectTimeout(5000);
            con.setReadTimeout(5000);
            con.setUseCaches(false);
            con.connect();
            StringWriter sw = new StringWriter();
            String enc = con.getContentEncoding() != null ? con.getContentEncoding() : "UTF-8";
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), enc));
            char[] buffer = new char[8192];
            while ((c = br.read(buffer)) != -1) {
                sw.write(buffer, 0, c);
            }
            return new String[]{sw.toString(), enc};
        }
        catch (IOException iOException) {
            return new String[]{"", "UTF-8"};
        }
    }
}

