/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.xmltool;

import com.mycila.xmltool.Utils;
import com.mycila.xmltool.ValidationResult;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XMLErrorHandler
implements ErrorHandler,
ValidationResult,
ErrorListener {
    private final List<Throwable> errors = new ArrayList<Throwable>();
    private final List<Throwable> warnings = new ArrayList<Throwable>();
    private final boolean throwExceptionOnError;

    XMLErrorHandler() {
        this(false);
    }

    XMLErrorHandler(boolean throwExceptionOnError) {
        this.throwExceptionOnError = throwExceptionOnError;
    }

    private void logError(Throwable cause) {
        this.errors.add(cause);
    }

    private void logWarning(Throwable cause) {
        this.warnings.add(cause);
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        this.logError(exception);
        if (this.throwExceptionOnError) {
            throw exception;
        }
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        this.error(exception);
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        this.logWarning(exception);
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.logWarning(exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.logError(exception);
        if (this.throwExceptionOnError) {
            throw exception;
        }
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.error(exception);
    }

    @Override
    public Throwable[] getErrors() {
        return this.errors.toArray(new Throwable[this.errors.size()]);
    }

    @Override
    public Throwable[] getWarnings() {
        return this.warnings.toArray(new Throwable[this.warnings.size()]);
    }

    @Override
    public String[] getErrorMessages() {
        return this.messages(this.errors);
    }

    @Override
    public String[] getWarningMessages() {
        return this.messages(this.warnings);
    }

    @Override
    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    @Override
    public boolean hasWarning() {
        return !this.warnings.isEmpty();
    }

    private String[] messages(List<Throwable> exceptions) {
        String[] msg = new String[exceptions.size()];
        int i = 0;
        for (Throwable exception : exceptions) {
            msg[i++] = Utils.getMessage(exception);
        }
        return msg;
    }
}

