/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.codegen;

import com.google.common.base.Objects;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeExtends;
import com.mysema.codegen.model.TypeSuper;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.Supertype;

public final class TypeResolver {
    public static Type resolve(Type type, Type declaringType, EntityType context) {
        Object resolved = TypeResolver.unwrap(type);
        String varName = TypeResolver.getVarName(resolved);
        if (varName != null) {
            resolved = TypeResolver.resolveVar(varName, declaringType, context);
        } else if (!resolved.getParameters().isEmpty()) {
            resolved = TypeResolver.resolveWithParameters(resolved, declaringType, context);
        }
        if (type instanceof EntityType) {
            resolved = !TypeResolver.unwrap(type).equals(resolved) ? new EntityType((Type)resolved, ((EntityType)type).getSuperTypes()) : type;
        }
        return resolved;
    }

    private static Type resolveVar(String varName, Type declaringType, EntityType context) {
        int index = -1;
        for (int i = 0; i < declaringType.getParameters().size(); ++i) {
            Type param = TypeResolver.unwrap((Type)declaringType.getParameters().get(i));
            if (!(param instanceof TypeExtends) || !Objects.equal((Object)((TypeExtends)param).getVarName(), (Object)varName)) continue;
            index = i;
        }
        if (index == -1) {
            throw new IllegalStateException("Did not find type " + varName + " in " + declaringType.getParameters());
        }
        Supertype type = context.getSuperType();
        while (!type.getEntityType().equals(declaringType)) {
            type = type.getEntityType().getSuperType();
        }
        return (Type)type.getType().getParameters().get(index);
    }

    private static Type resolveWithParameters(Type type, Type declaringType, EntityType context) {
        Type[] params = new Type[type.getParameters().size()];
        boolean transformed = false;
        for (int i = 0; i < type.getParameters().size(); ++i) {
            Type param = (Type)type.getParameters().get(i);
            if (param == null || param.getFullName().equals(type.getFullName())) continue;
            params[i] = TypeResolver.resolve(param, declaringType, context);
            if (params[i].equals(param)) continue;
            transformed = true;
        }
        if (transformed) {
            return new SimpleType(type, params);
        }
        return type;
    }

    private static String getVarName(Type type) {
        if (type instanceof TypeExtends) {
            return ((TypeExtends)type).getVarName();
        }
        if (type instanceof TypeSuper) {
            return ((TypeSuper)type).getVarName();
        }
        return null;
    }

    private static Type unwrap(Type type) {
        if (type instanceof EntityType) {
            return ((EntityType)type).getInnerType();
        }
        return type;
    }

    private TypeResolver() {
    }
}

