/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.CollectionExpression;
import com.mysema.query.types.Constant;
import com.mysema.query.types.ConstantImpl;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OperationImpl;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.PredicateOperation;
import com.mysema.query.types.TemplateExpressionImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class ExpressionUtils {
    public static <T> Expression<T> all(CollectionExpression<?, ? super T> col) {
        return OperationImpl.create(col.getParameter(0), Ops.QuantOps.ALL, col);
    }

    public static <T> Expression<T> any(CollectionExpression<?, ? super T> col) {
        return OperationImpl.create(col.getParameter(0), Ops.QuantOps.ANY, col);
    }

    @Nullable
    public static Predicate allOf(Collection<Predicate> exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.and(rv, b);
        }
        return rv;
    }

    @Nullable
    public static Predicate allOf(Predicate ... exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.and(rv, b);
        }
        return rv;
    }

    public static Predicate and(Predicate left, Predicate right) {
        return new PredicateOperation(Ops.AND, left, right);
    }

    @Nullable
    public static Predicate anyOf(Collection<Predicate> exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.or(rv, b);
        }
        return rv;
    }

    @Nullable
    public static Predicate anyOf(Predicate ... exprs) {
        Predicate rv = null;
        for (Predicate b : exprs) {
            if (b == null) continue;
            rv = rv == null ? b : ExpressionUtils.or(rv, b);
        }
        return rv;
    }

    public static <D> Expression<D> as(Expression<D> source, Path<D> alias) {
        return new OperationImpl<Object>(alias.getType(), Ops.ALIAS, source, alias);
    }

    public static <D> Expression<D> as(Expression<D> source, String alias) {
        return ExpressionUtils.as(source, new PathImpl<D>(source.getType(), alias));
    }

    public static Expression<Long> count(Expression<?> source) {
        return OperationImpl.create(Long.class, Ops.AggOps.COUNT_AGG, source);
    }

    public static <D> Predicate eqConst(Expression<D> left, D constant) {
        return ExpressionUtils.eq(left, new ConstantImpl<D>(constant));
    }

    public static <D> Predicate eq(Expression<D> left, Expression<? extends D> right) {
        return new PredicateOperation(Ops.EQ, left, right);
    }

    public static <D> Predicate in(Expression<D> left, CollectionExpression<?, ? extends D> right) {
        return new PredicateOperation(Ops.IN, left, right);
    }

    public static <D> Predicate in(Expression<D> left, Collection<? extends D> right) {
        if (right.size() == 1) {
            return ExpressionUtils.eqConst(left, right.iterator().next());
        }
        return new PredicateOperation(Ops.IN, left, new ConstantImpl<Collection<? extends D>>(right));
    }

    public static Predicate isNull(Expression<?> left) {
        return new PredicateOperation(Ops.IS_NULL, left);
    }

    public static Predicate isNotNull(Expression<?> left) {
        return new PredicateOperation(Ops.IS_NOT_NULL, left);
    }

    public static Expression<String> likeToRegex(Expression<String> expr) {
        return ExpressionUtils.likeToRegex(expr, true);
    }

    public static Expression<String> likeToRegex(Expression<String> expr, boolean matchStartAndEnd) {
        if (expr instanceof Constant) {
            String like = expr.toString();
            if (matchStartAndEnd) {
                if (!like.startsWith("%")) {
                    like = "^" + like;
                }
                if (!like.endsWith("%")) {
                    like = like + "$";
                }
            }
            like = like.replace(".", "\\.").replace("*", "\\*").replace("?", "\\?").replace("%", ".*").replace("_", ".");
            return ConstantImpl.create(like);
        }
        if (expr instanceof Operation) {
            Operation o = (Operation)expr;
            if (o.getOperator() == Ops.CONCAT) {
                Expression<String> lhs = ExpressionUtils.likeToRegex(o.getArg(0), false);
                Expression<String> rhs = ExpressionUtils.likeToRegex(o.getArg(1), false);
                return new OperationImpl<String>(String.class, Ops.CONCAT, lhs, rhs);
            }
            return expr;
        }
        return expr;
    }

    public static Expression<?> list(Expression<?> ... exprs) {
        return ExpressionUtils.list(Arrays.asList(exprs));
    }

    public static Expression<?> list(List<? extends Expression<?>> exprs) {
        Expression<?> rv = exprs.get(0);
        for (int i = 1; i < exprs.size(); ++i) {
            rv = OperationImpl.create(Object.class, Ops.LIST, rv, exprs.get(i));
        }
        return rv;
    }

    public static Expression<?> merge(List<? extends Expression<?>> expressions) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < expressions.size(); ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append("{" + i + "}");
        }
        return TemplateExpressionImpl.create(Object.class, builder.toString(), expressions.toArray(new Expression[expressions.size()]));
    }

    public static Expression<String> regexToLike(Expression<String> expr) {
        if (expr instanceof Constant) {
            return ConstantImpl.create(expr.toString().replace(".*", "%").replace(".", "_"));
        }
        if (expr instanceof Operation) {
            Operation o = (Operation)expr;
            if (o.getOperator() == Ops.CONCAT) {
                Expression<String> lhs = ExpressionUtils.regexToLike(o.getArg(0));
                Expression<String> rhs = ExpressionUtils.regexToLike(o.getArg(1));
                return new OperationImpl<String>(String.class, Ops.CONCAT, lhs, rhs);
            }
            return expr;
        }
        return expr;
    }

    public static <D> Predicate neConst(Expression<D> left, D constant) {
        return ExpressionUtils.ne(left, new ConstantImpl<D>(constant));
    }

    public static <D> Predicate ne(Expression<D> left, Expression<? super D> right) {
        return new PredicateOperation(Ops.NE, left, right);
    }

    public static Predicate or(Predicate left, Predicate right) {
        return new PredicateOperation(Ops.OR, left, right);
    }

    private ExpressionUtils() {
    }
}

