/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.base.Function;
import com.mysema.query.types.Expression;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;

public final class Template
implements Serializable {
    private static final long serialVersionUID = -1697705745769542204L;
    private final List<Element> elements;
    private final String template;

    Template(String template, List<Element> elements) {
        this.template = template;
        this.elements = elements;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public String toString() {
        return this.template;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Template) {
            return ((Template)o).template.equals(this.template);
        }
        return false;
    }

    public int hashCode() {
        return this.template.hashCode();
    }

    public static final class Element
    implements Serializable {
        private static final long serialVersionUID = -6861235060996903489L;
        private final int index;
        @Nullable
        private final String staticText;
        @Nullable
        private final transient Function<Expression<?>, Expression<?>> transformer;
        private final boolean asString;
        private final String toString;

        Element(int index, Function<? extends Expression<?>, ? extends Expression<?>> transformer) {
            this.asString = false;
            this.transformer = transformer;
            this.index = index;
            this.staticText = null;
            this.toString = String.valueOf(index);
        }

        Element(int index, boolean asString) {
            this.asString = asString;
            this.transformer = null;
            this.index = index;
            this.staticText = null;
            this.toString = index + (asString ? "s" : "");
        }

        Element(String text) {
            this.asString = false;
            this.transformer = null;
            this.index = -1;
            this.staticText = text;
            this.toString = "'" + this.staticText + "'";
        }

        public int getIndex() {
            return this.index;
        }

        @Nullable
        public String getStaticText() {
            return this.staticText;
        }

        public boolean isAsString() {
            return this.asString;
        }

        public boolean hasConverter() {
            return this.transformer != null;
        }

        public Expression<?> convert(Expression<?> source) {
            return (Expression)this.transformer.apply(source);
        }

        public String toString() {
            return this.toString;
        }
    }
}

