/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class MathUtils {
    private MathUtils() {
    }

    public static <D extends Number> D sum(D num1, Number num2) {
        BigDecimal res = new BigDecimal(num1.toString()).add(new BigDecimal(num2.toString()));
        return (D)MathUtils.cast(res, num1.getClass());
    }

    public static <D extends Number> D difference(D num1, Number num2) {
        BigDecimal res = new BigDecimal(num1.toString()).subtract(new BigDecimal(num2.toString()));
        return (D)MathUtils.cast(res, num1.getClass());
    }

    public static <D extends Number> D cast(Number num, Class<D> type) {
        Number rv;
        if (type.equals(Byte.class)) {
            rv = num.byteValue();
        } else if (type.equals(Double.class)) {
            rv = num.doubleValue();
        } else if (type.equals(Float.class)) {
            rv = Float.valueOf(num.floatValue());
        } else if (type.equals(Integer.class)) {
            rv = num.intValue();
        } else if (type.equals(Long.class)) {
            rv = num.longValue();
        } else if (type.equals(Short.class)) {
            rv = num.shortValue();
        } else if (type.equals(BigDecimal.class)) {
            rv = num instanceof BigDecimal ? num : new BigDecimal(num.toString());
        } else if (type.equals(BigInteger.class)) {
            rv = num instanceof BigInteger ? num : (num instanceof BigDecimal ? ((BigDecimal)num).toBigInteger() : new BigInteger(num.toString()));
        } else {
            throw new IllegalArgumentException(String.format("Illegal type : %s", type.getSimpleName()));
        }
        return (D)rv;
    }
}

