/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathMetadata;
import com.mysema.query.types.PathType;
import javax.annotation.Nonnegative;

public final class PathMetadataFactory {
    public static PathMetadata<Integer> forArrayAccess(Path<?> parent, Expression<Integer> index) {
        return new PathMetadata<Integer>(parent, index, PathType.ARRAYVALUE);
    }

    public static PathMetadata<Integer> forArrayAccess(Path<?> parent, @Nonnegative int index) {
        return new PathMetadata<Integer>(parent, index, PathType.ARRAYVALUE_CONSTANT);
    }

    public static PathMetadata<?> forCollectionAny(Path<?> parent) {
        return new PathMetadata(parent, "", PathType.COLLECTION_ANY);
    }

    public static <T> PathMetadata<T> forDelegate(Path<T> delegate) {
        return new PathMetadata(delegate, delegate, PathType.DELEGATE);
    }

    public static PathMetadata<Integer> forListAccess(Path<?> parent, Expression<Integer> index) {
        return new PathMetadata<Integer>(parent, index, PathType.LISTVALUE);
    }

    public static PathMetadata<Integer> forListAccess(Path<?> parent, @Nonnegative int index) {
        return new PathMetadata<Integer>(parent, index, PathType.LISTVALUE_CONSTANT);
    }

    public static <KT> PathMetadata<KT> forMapAccess(Path<?> parent, Expression<KT> key) {
        return new PathMetadata(parent, key, PathType.MAPVALUE);
    }

    public static <KT> PathMetadata<KT> forMapAccess(Path<?> parent, KT key) {
        return new PathMetadata(parent, key, PathType.MAPVALUE_CONSTANT);
    }

    public static PathMetadata<String> forProperty(Path<?> parent, String property) {
        return new PathMetadata<String>(parent, property, PathType.PROPERTY);
    }

    public static PathMetadata<String> forVariable(String variable) {
        return new PathMetadata<String>(null, variable, PathType.VARIABLE);
    }

    private PathMetadataFactory() {
    }
}

