/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.support.NumberConversion;
import com.mysema.query.support.NumberConversions;
import com.mysema.query.types.Expression;
import com.mysema.query.types.FactoryExpression;
import com.mysema.query.types.Operation;
import com.mysema.query.types.Ops;

public final class Conversions {
    public static <RT> Expression<RT> convert(Expression<RT> expr) {
        if (Conversions.isAggSumWithConversion(expr) || Conversions.isCountAggConversion(expr)) {
            return new NumberConversion(expr);
        }
        if (expr instanceof FactoryExpression) {
            FactoryExpression factorye = (FactoryExpression)expr;
            for (Expression e : factorye.getArgs()) {
                if (!Conversions.isAggSumWithConversion(e) && !Conversions.isCountAggConversion(expr)) continue;
                return new NumberConversions(factorye);
            }
        }
        return expr;
    }

    private static boolean isAggSumWithConversion(Expression<?> expr) {
        Class type;
        return expr instanceof Operation && ((Operation)expr).getOperator() == Ops.AggOps.SUM_AGG && ((type = ((Operation)expr).getType()).equals(Float.class) || type.equals(Integer.class) || type.equals(Short.class) || type.equals(Byte.class));
    }

    private static boolean isCountAggConversion(Expression<?> expr) {
        return expr instanceof Operation && ((Operation)expr).getOperator() == Ops.AggOps.COUNT_AGG;
    }
}

