/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.query.BooleanBuilder;
import com.mysema.query.JoinExpression;
import com.mysema.query.JoinFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.jpa.Conversions;
import com.mysema.query.jpa.JPQLCollectionAnyVisitor;
import com.mysema.query.support.Context;
import com.mysema.query.support.ListAccessVisitor;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.EntityPath;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.TemplateExpressionImpl;
import com.mysema.query.types.Visitor;
import com.mysema.query.types.path.ListPath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JPQLQueryMixin<T>
extends QueryMixin<T> {
    private final Set<Path<?>> paths = new HashSet();
    public static final JoinFlag FETCH = new JoinFlag("fetch ");
    public static final JoinFlag FETCH_ALL_PROPERTIES = new JoinFlag(" fetch all properties");

    public JPQLQueryMixin() {
    }

    public JPQLQueryMixin(QueryMetadata metadata) {
        super(metadata);
    }

    public JPQLQueryMixin(T self, QueryMetadata metadata) {
        super(self, metadata);
    }

    public T fetch() {
        List joins = this.getMetadata().getJoins();
        ((JoinExpression)joins.get(joins.size() - 1)).addFlag(FETCH);
        return (T)this.getSelf();
    }

    public T fetchAll() {
        List joins = this.getMetadata().getJoins();
        ((JoinExpression)joins.get(joins.size() - 1)).addFlag(FETCH_ALL_PROPERTIES);
        return (T)this.getSelf();
    }

    public T with(Predicate ... conditions) {
        for (Predicate condition : this.normalize(conditions, false)) {
            this.getMetadata().addJoinCondition(condition);
        }
        return (T)this.getSelf();
    }

    public <RT> Expression<RT> convert(Expression<RT> expr) {
        return super.convert(Conversions.convert(expr));
    }

    protected Predicate normalize(Predicate predicate, boolean where) {
        if (predicate instanceof BooleanBuilder && ((BooleanBuilder)predicate).getValue() == null) {
            return predicate;
        }
        predicate = (Predicate)predicate.accept((Visitor)JPQLCollectionAnyVisitor.DEFAULT, (Object)new Context());
        Context context = new Context();
        predicate = (Predicate)predicate.accept((Visitor)ListAccessVisitor.DEFAULT, (Object)context);
        for (int i = 0; i < context.paths.size(); ++i) {
            Path path = (Path)context.paths.get(i);
            if (this.paths.contains(path)) continue;
            this.addCondition(context, i, path, where);
        }
        return predicate;
    }

    private void addCondition(Context context, int i, Path<?> path, boolean where) {
        this.paths.add(path);
        EntityPath alias = (EntityPath)context.replacements.get(i);
        this.leftJoin((Path)((ListPath)path.getMetadata().getParent()), (Path)context.replacements.get(i));
        Expression index = TemplateExpressionImpl.create(Integer.class, (String)"index({0})", (Expression[])new Expression[]{alias});
        Predicate condition = ExpressionUtils.eq((Expression)index, (Expression)path.getMetadata().getExpression());
        if (where) {
            super.where(new Predicate[]{condition});
        } else {
            super.having(new Predicate[]{condition});
        }
    }
}

