/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.jpa;

import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.jpa.QueryHandler;
import com.mysema.query.jpa.TransformingIterator;
import com.mysema.query.types.FactoryExpression;
import java.io.Closeable;
import java.io.IOException;
import javax.persistence.Query;
import org.eclipse.persistence.jpa.JpaQuery;
import org.eclipse.persistence.queries.Cursor;

public class EclipseLinkHandler
implements QueryHandler {
    @Override
    public void addEntity(Query query, String alias, Class<?> type) {
    }

    @Override
    public void addScalar(Query query, String alias, Class<?> type) {
    }

    @Override
    public boolean createNativeQueryTyped() {
        return true;
    }

    @Override
    public <T> CloseableIterator<T> iterate(Query query, FactoryExpression<?> projection) {
        Cursor iterator = null;
        Closeable closeable = null;
        if (query instanceof JpaQuery) {
            JpaQuery elQuery = (JpaQuery)query;
            elQuery.setHint("eclipselink.cursor.scrollable.result-set-type", (Object)"ForwardOnly");
            elQuery.setHint("eclipselink.cursor.scrollable", (Object)true);
            final Cursor cursor = elQuery.getResultCursor();
            closeable = new Closeable(){

                @Override
                public void close() throws IOException {
                    cursor.close();
                }
            };
            iterator = cursor;
        } else {
            iterator = query.getResultList().iterator();
        }
        if (projection != null) {
            return new TransformingIterator(iterator, closeable, projection);
        }
        return new IteratorAdapter(iterator, closeable);
    }

    @Override
    public boolean transform(Query query, FactoryExpression<?> projection) {
        return false;
    }

    @Override
    public boolean wrapEntityProjections() {
        return false;
    }
}

