/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.lucene;

import com.google.common.base.Function;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.commons.lang.EmptyCloseableIterator;
import com.mysema.commons.lang.IteratorAdapter;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.QueryException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.SimpleProjectable;
import com.mysema.query.SimpleQuery;
import com.mysema.query.lucene.LuceneSerializer;
import com.mysema.query.lucene.ResultIterator;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Expression;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.search.DuplicateFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;

public abstract class AbstractLuceneQuery<T, Q extends AbstractLuceneQuery<T, Q>>
implements SimpleQuery<Q>,
SimpleProjectable<T> {
    private final QueryMixin<Q> queryMixin = new QueryMixin((Object)this, (QueryMetadata)new DefaultQueryMetadata().noValidate());
    private final Searcher searcher;
    private final LuceneSerializer serializer;
    private final Function<Document, T> transformer;
    @Nullable
    private FieldSelector fieldSelector;
    @Nullable
    private Filter filter;
    @Nullable
    private Sort querySort;

    public AbstractLuceneQuery(LuceneSerializer serializer, Searcher searcher, Function<Document, T> transformer) {
        this.serializer = serializer;
        this.searcher = searcher;
        this.transformer = transformer;
    }

    public AbstractLuceneQuery(Searcher searcher, Function<Document, T> transformer) {
        this(LuceneSerializer.DEFAULT, searcher, transformer);
    }

    public boolean exists() {
        return this.innerCount() > 0L;
    }

    public boolean notExists() {
        return this.innerCount() == 0L;
    }

    private long innerCount() {
        try {
            int maxDoc = this.searcher.maxDoc();
            if (maxDoc == 0) {
                return 0L;
            }
            return this.searcher.search((Query)this.createQuery(), (Filter)this.filter, (int)maxDoc).totalHits;
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public long count() {
        return this.innerCount();
    }

    public long countDistinct() {
        throw new UnsupportedOperationException("use distinct(path) instead");
    }

    private Query createQuery() {
        if (this.queryMixin.getMetadata().getWhere() == null) {
            return new MatchAllDocsQuery();
        }
        return this.serializer.toQuery((Expression<?>)this.queryMixin.getMetadata().getWhere(), this.queryMixin.getMetadata());
    }

    public Q distinct() {
        throw new UnsupportedOperationException("use distinct(path) instead");
    }

    public Q distinct(Path<?> property) {
        return this.filter((Filter)new DuplicateFilter(this.serializer.toField(property)));
    }

    public Q filter(Filter filter) {
        this.filter = filter;
        return (Q)this;
    }

    public Q limit(long limit) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.limit(limit));
    }

    public CloseableIterator<T> iterate() {
        int limit;
        QueryMetadata metadata = this.queryMixin.getMetadata();
        List orderBys = metadata.getOrderBy();
        Long queryLimit = metadata.getModifiers().getLimit();
        Long queryOffset = metadata.getModifiers().getOffset();
        Sort sort = this.querySort;
        int offset = queryOffset != null ? queryOffset.intValue() : 0;
        try {
            limit = this.maxDoc();
            if (limit == 0) {
                return new EmptyCloseableIterator();
            }
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
        if (queryLimit != null && queryLimit.intValue() < limit) {
            limit = queryLimit.intValue();
        }
        if (sort == null && !orderBys.isEmpty()) {
            sort = this.serializer.toSort(orderBys);
        }
        try {
            int sumOfLimitAndOffset = limit + offset;
            if (sumOfLimitAndOffset < 1) {
                throw new QueryException("The given limit (" + limit + ") and offset (" + offset + ") cause an integer overflow.");
            }
            ScoreDoc[] scoreDocs = sort != null ? this.searcher.search((Query)this.createQuery(), (Filter)this.filter, (int)sumOfLimitAndOffset, (Sort)sort).scoreDocs : this.searcher.search((Query)this.createQuery(), (Filter)this.filter, (int)sumOfLimitAndOffset).scoreDocs;
            if (offset < scoreDocs.length) {
                return new ResultIterator<T>(scoreDocs, offset, this.searcher, this.fieldSelector, this.transformer);
            }
            return new EmptyCloseableIterator();
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public CloseableIterator<T> iterateDistinct() {
        throw new UnsupportedOperationException("use distinct(path) instead");
    }

    private List<T> innerList() {
        return new IteratorAdapter(this.iterate()).asList();
    }

    public List<T> list() {
        return this.innerList();
    }

    public Q load(FieldSelector fieldSelector) {
        this.fieldSelector = fieldSelector;
        return (Q)this;
    }

    public Q load(Path<?> ... paths) {
        ArrayList<String> fields = new ArrayList<String>(paths.length);
        for (Path<?> path : paths) {
            fields.add(this.serializer.toField(path));
        }
        this.fieldSelector = new MapFieldSelector(fields);
        return (Q)this;
    }

    public List<T> listDistinct() {
        throw new UnsupportedOperationException("use distinct(path) instead");
    }

    public SearchResults<T> listDistinctResults() {
        throw new UnsupportedOperationException("use distinct(path) instead");
    }

    public SearchResults<T> listResults() {
        List<T> documents = this.innerList();
        return new SearchResults(documents, this.queryMixin.getMetadata().getModifiers(), this.innerCount());
    }

    public Q offset(long offset) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.offset(offset));
    }

    public Q orderBy(OrderSpecifier<?> ... o) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.orderBy(o));
    }

    public Q restrict(QueryModifiers modifiers) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.restrict(modifiers));
    }

    public <P> Q set(ParamExpression<P> param, P value) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.set(param, value));
    }

    public Q sort(Sort sort) {
        this.querySort = sort;
        return (Q)this;
    }

    @Nullable
    private T oneResult(boolean unique) {
        try {
            int maxDoc = this.maxDoc();
            if (maxDoc == 0) {
                return null;
            }
            ScoreDoc[] scoreDocs = this.searcher.search((Query)this.createQuery(), (Filter)this.filter, (int)maxDoc).scoreDocs;
            int index = 0;
            QueryModifiers modifiers = this.queryMixin.getMetadata().getModifiers();
            Long offset = modifiers.getOffset();
            if (offset != null) {
                index = offset.intValue();
            }
            Long limit = modifiers.getLimit();
            if (unique && (limit == null ? scoreDocs.length - index > 1 : limit > 1L && scoreDocs.length > 1)) {
                throw new NonUniqueResultException("Unique result requested, but " + scoreDocs.length + " found.");
            }
            if (scoreDocs.length > index) {
                Document document = this.fieldSelector != null ? this.searcher.doc(scoreDocs[index].doc, this.fieldSelector) : this.searcher.doc(scoreDocs[index].doc);
                return (T)this.transformer.apply((Object)document);
            }
            return null;
        }
        catch (IOException e) {
            throw new QueryException((Throwable)e);
        }
    }

    public T singleResult() {
        return this.oneResult(false);
    }

    public T uniqueResult() {
        return this.oneResult(true);
    }

    public Q where(Predicate ... e) {
        return (Q)((AbstractLuceneQuery)this.queryMixin.where(e));
    }

    public String toString() {
        return this.createQuery().toString();
    }

    private int maxDoc() throws IOException {
        return this.searcher.maxDoc();
    }
}

