/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.maven;

import com.mysema.query.codegen.BeanSerializer;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.sql.Configuration;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.sql.codegen.DefaultNamingStrategy;
import com.mysema.query.sql.codegen.MetaDataExporter;
import com.mysema.query.sql.codegen.NamingStrategy;
import com.mysema.query.sql.types.Type;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class AbstractMetaDataExportMojo
extends AbstractMojo {
    private MavenProject project;
    private String jdbcDriver;
    private String jdbcUrl;
    private String jdbcUser;
    private String jdbcPassword;
    private String namePrefix;
    private String nameSuffix;
    private String beanPrefix;
    private String beanSuffix;
    private String packageName;
    private String beanPackageName;
    private String schemaPattern;
    private String tableNamePattern;
    private String targetFolder;
    private String namingStrategyClass;
    private String beanSerializerClass;
    private String serializerClass;
    private boolean exportBeans;
    private boolean innerClassesForKeys;
    private boolean validationAnnotations;
    private boolean columnAnnotations;
    private String[] customTypes;
    private boolean createScalaSources;
    private boolean schemaToPackage;
    private boolean lowerCase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        String sourceEncoding;
        DefaultNamingStrategy namingStrategy;
        if (this.isForTest()) {
            this.project.addTestCompileSourceRoot(this.targetFolder);
        } else {
            this.project.addCompileSourceRoot(this.targetFolder);
        }
        if (this.namingStrategyClass != null) {
            try {
                namingStrategy = (NamingStrategy)Class.forName(this.namingStrategyClass).newInstance();
            }
            catch (InstantiationException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            catch (ClassNotFoundException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        } else {
            namingStrategy = new DefaultNamingStrategy();
        }
        if (this.createScalaSources) {
            if (this.serializerClass == null) {
                this.serializerClass = "com.mysema.query.scala.sql.ScalaMetaDataSerializer";
            }
            if (this.exportBeans && this.beanSerializerClass == null) {
                this.beanSerializerClass = "com.mysema.query.scala.ScalaBeanSerializer";
            }
        }
        MetaDataExporter exporter = new MetaDataExporter();
        if (this.namePrefix != null) {
            exporter.setNamePrefix(this.namePrefix);
        }
        if (this.nameSuffix != null) {
            exporter.setNameSuffix(this.nameSuffix);
        }
        if (this.beanPrefix != null) {
            exporter.setBeanPrefix(this.beanPrefix);
        }
        if (this.beanSuffix != null) {
            exporter.setBeanSuffix(this.beanSuffix);
        }
        exporter.setCreateScalaSources(this.createScalaSources);
        exporter.setPackageName(this.packageName);
        exporter.setBeanPackageName(this.beanPackageName);
        exporter.setInnerClassesForKeys(this.innerClassesForKeys);
        exporter.setTargetFolder(new File(this.targetFolder));
        exporter.setNamingStrategy((NamingStrategy)namingStrategy);
        exporter.setSchemaPattern(this.schemaPattern);
        exporter.setTableNamePattern(this.tableNamePattern);
        exporter.setColumnAnnotations(this.columnAnnotations);
        exporter.setValidationAnnotations(this.validationAnnotations);
        exporter.setSchemaToPackage(this.schemaToPackage);
        exporter.setLowerCase(this.lowerCase);
        if (this.serializerClass != null) {
            try {
                exporter.setSerializerClass(Class.forName(this.serializerClass));
            }
            catch (ClassNotFoundException e) {
                this.getLog().error((Throwable)e);
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.exportBeans) {
            if (this.beanSerializerClass != null) {
                try {
                    exporter.setBeanSerializerClass(Class.forName(this.beanSerializerClass));
                }
                catch (ClassNotFoundException e) {
                    this.getLog().error((Throwable)e);
                    throw new MojoExecutionException(e.getMessage(), (Exception)e);
                }
            } else {
                exporter.setBeanSerializer((Serializer)new BeanSerializer());
            }
        }
        if ((sourceEncoding = (String)this.project.getProperties().get("project.build.sourceEncoding")) != null) {
            exporter.setSourceEncoding(sourceEncoding);
        }
        try {
            if (this.customTypes != null) {
                Configuration configuration = new Configuration(SQLTemplates.DEFAULT);
                for (String cl : this.customTypes) {
                    configuration.register((Type)Class.forName(cl).newInstance());
                }
                exporter.setConfiguration(configuration);
            }
        }
        catch (IllegalAccessException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InstantiationException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        try {
            Class.forName(this.jdbcDriver);
            Connection conn = DriverManager.getConnection(this.jdbcUrl, this.jdbcUser, this.jdbcPassword);
            try {
                exporter.export(conn.getMetaData());
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    protected boolean isForTest() {
        return false;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public void setBeanPrefix(String beanPrefix) {
        this.beanPrefix = beanPrefix;
    }

    public void setBeanSuffix(String beanSuffix) {
        this.beanSuffix = beanSuffix;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setBeanPackageName(String beanPackageName) {
        this.beanPackageName = beanPackageName;
    }

    public void setSchemaPattern(String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public void setTableNamePattern(String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setTargetFolder(String targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setNamingStrategyClass(String namingStrategyClass) {
        this.namingStrategyClass = namingStrategyClass;
    }

    public void setBeanSerializerClass(String beanSerializerClass) {
        this.beanSerializerClass = beanSerializerClass;
    }

    public void setSerializerClass(String serializerClass) {
        this.serializerClass = serializerClass;
    }

    public void setExportBeans(boolean exportBeans) {
        this.exportBeans = exportBeans;
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.innerClassesForKeys = innerClassesForKeys;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public void setCustomTypes(String[] customTypes) {
        this.customTypes = customTypes;
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }
}

