/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.mongodb;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.DefaultQueryMetadata;
import com.mysema.query.JoinExpression;
import com.mysema.query.NonUniqueResultException;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.SearchResults;
import com.mysema.query.SimpleProjectable;
import com.mysema.query.SimpleQuery;
import com.mysema.query.mongodb.AnyEmbeddedBuilder;
import com.mysema.query.mongodb.JoinBuilder;
import com.mysema.query.mongodb.MongodbSerializer;
import com.mysema.query.support.QueryMixin;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.Operation;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.ParamExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.path.CollectionPathBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public abstract class MongodbQuery<K>
implements SimpleQuery<MongodbQuery<K>>,
SimpleProjectable<K> {
    private final MongodbSerializer serializer;
    private final QueryMixin<MongodbQuery<K>> queryMixin = new QueryMixin((Object)this, (QueryMetadata)new DefaultQueryMetadata().noValidate());
    private final DBCollection collection;
    private final Function<DBObject, K> transformer;

    public MongodbQuery(DBCollection collection, Function<DBObject, K> transformer, MongodbSerializer serializer) {
        this.transformer = transformer;
        this.collection = collection;
        this.serializer = serializer;
    }

    public <T> JoinBuilder<K, T> join(Path<T> ref, Path<T> target) {
        return new JoinBuilder<K, T>(this.queryMixin, ref, target);
    }

    public <T> JoinBuilder<K, T> join(CollectionPathBase<?, T, ?> ref, Path<T> target) {
        return new JoinBuilder<K, T>(this.queryMixin, (Path<?>)ref, target);
    }

    public <T> AnyEmbeddedBuilder<K> anyEmbedded(Path<? extends Collection<T>> collection, Path<T> target) {
        return new AnyEmbeddedBuilder<K>(this.queryMixin, collection);
    }

    protected abstract DBCollection getCollection(Class<?> var1);

    public boolean exists() {
        try {
            QueryMetadata metadata = this.queryMixin.getMetadata();
            Predicate filter = this.createFilter(metadata);
            return this.collection.findOne(this.createQuery(filter)) != null;
        }
        catch (NoResults ex) {
            return false;
        }
    }

    @Nullable
    protected Predicate createFilter(QueryMetadata metadata) {
        Predicate filter = !metadata.getJoins().isEmpty() ? ExpressionUtils.allOf((Predicate[])new Predicate[]{metadata.getWhere(), this.createJoinFilter(metadata)}) : metadata.getWhere();
        return filter;
    }

    @Nullable
    protected Predicate createJoinFilter(QueryMetadata metadata) {
        HashMultimap predicates = HashMultimap.create();
        List joins = metadata.getJoins();
        for (int i = joins.size() - 1; i >= 0; --i) {
            JoinExpression join = (JoinExpression)joins.get(i);
            Path source = (Path)((Operation)join.getTarget()).getArg(0);
            Path target = (Path)((Operation)join.getTarget()).getArg(1);
            Collection extraFilters = predicates.get((Object)target.getRoot());
            Predicate filter = ExpressionUtils.allOf((Predicate[])new Predicate[]{join.getCondition(), this.allOf(extraFilters)});
            List<Object> ids = this.getIds(target.getType(), filter);
            if (ids.isEmpty()) {
                throw new NoResults();
            }
            PathImpl path = new PathImpl(String.class, source, "$id");
            predicates.put((Object)source.getRoot(), (Object)ExpressionUtils.in((Expression)path, ids));
        }
        Path source = (Path)((Operation)((JoinExpression)joins.get(0)).getTarget()).getArg(0);
        return this.allOf(predicates.get((Object)source.getRoot()));
    }

    private Predicate allOf(Collection<Predicate> predicates) {
        return predicates != null ? ExpressionUtils.allOf(predicates) : null;
    }

    protected List<Object> getIds(Class<?> targetType, Predicate condition) {
        DBCollection collection = this.getCollection(targetType);
        DBCursor cursor = this.createCursor(collection, condition, QueryModifiers.EMPTY, Collections.<OrderSpecifier<?>>emptyList());
        if (cursor.hasNext()) {
            ArrayList<Object> ids = new ArrayList<Object>(cursor.count());
            for (DBObject obj : cursor) {
                ids.add(obj.get("_id"));
            }
            return ids;
        }
        return Collections.emptyList();
    }

    public boolean notExists() {
        return !this.exists();
    }

    public MongodbQuery<K> distinct() {
        return (MongodbQuery)this.queryMixin.distinct();
    }

    public MongodbQuery<K> where(Predicate ... e) {
        return (MongodbQuery)this.queryMixin.where(e);
    }

    public MongodbQuery<K> limit(long limit) {
        return (MongodbQuery)this.queryMixin.limit(limit);
    }

    public MongodbQuery<K> offset(long offset) {
        return (MongodbQuery)this.queryMixin.offset(offset);
    }

    public MongodbQuery<K> restrict(QueryModifiers modifiers) {
        return (MongodbQuery)this.queryMixin.restrict(modifiers);
    }

    public MongodbQuery<K> orderBy(OrderSpecifier<?> ... o) {
        return (MongodbQuery)this.queryMixin.orderBy(o);
    }

    public <T> MongodbQuery<K> set(ParamExpression<T> param, T value) {
        return (MongodbQuery)this.queryMixin.set(param, value);
    }

    public CloseableIterator<K> iterate() {
        final DBCursor cursor = this.createCursor();
        return new CloseableIterator<K>(){

            public boolean hasNext() {
                return cursor.hasNext();
            }

            public K next() {
                return MongodbQuery.this.transformer.apply((Object)cursor.next());
            }

            public void remove() {
            }

            public void close() {
            }
        };
    }

    public CloseableIterator<K> iterateDistinct() {
        return this.iterate();
    }

    public List<K> list() {
        try {
            DBCursor cursor = this.createCursor();
            ArrayList<Object> results = new ArrayList<Object>(cursor.size());
            for (DBObject dbObject : cursor) {
                results.add(this.transformer.apply((Object)dbObject));
            }
            return results;
        }
        catch (NoResults ex) {
            return Collections.emptyList();
        }
    }

    protected DBCursor createCursor() {
        QueryMetadata metadata = this.queryMixin.getMetadata();
        Predicate filter = this.createFilter(metadata);
        return this.createCursor(this.collection, filter, metadata.getModifiers(), metadata.getOrderBy());
    }

    protected DBCursor createCursor(DBCollection collection, @Nullable Predicate where, QueryModifiers modifiers, List<OrderSpecifier<?>> orderBy) {
        DBCursor cursor = collection.find(this.createQuery(where));
        if (modifiers.getLimit() != null) {
            cursor.limit(modifiers.getLimit().intValue());
        }
        if (modifiers.getOffset() != null) {
            cursor.skip(modifiers.getOffset().intValue());
        }
        if (orderBy.size() > 0) {
            cursor.sort(this.serializer.toSort(orderBy));
        }
        return cursor;
    }

    public List<K> listDistinct() {
        return this.list();
    }

    public K singleResult() {
        try {
            DBCursor c = this.createCursor().limit(1);
            if (c.hasNext()) {
                return (K)this.transformer.apply((Object)c.next());
            }
            return null;
        }
        catch (NoResults ex) {
            return null;
        }
    }

    public K uniqueResult() {
        try {
            DBCursor c;
            Long limit = this.queryMixin.getMetadata().getModifiers().getLimit();
            if (limit == null) {
                limit = 2L;
            }
            if ((c = this.createCursor().limit(limit.intValue())).hasNext()) {
                Object rv = this.transformer.apply((Object)c.next());
                if (c.hasNext()) {
                    throw new NonUniqueResultException();
                }
                return (K)rv;
            }
            return null;
        }
        catch (NoResults ex) {
            return null;
        }
    }

    public SearchResults<K> listResults() {
        try {
            long total = this.count();
            if (total > 0L) {
                return new SearchResults(this.list(), this.queryMixin.getMetadata().getModifiers(), total);
            }
            return SearchResults.emptyResults();
        }
        catch (NoResults ex) {
            return SearchResults.emptyResults();
        }
    }

    public SearchResults<K> listDistinctResults() {
        return this.listResults();
    }

    public long count() {
        try {
            Predicate filter = this.createFilter(this.queryMixin.getMetadata());
            return this.collection.count(this.createQuery(filter));
        }
        catch (NoResults ex) {
            return 0L;
        }
    }

    public long countDistinct() {
        return this.count();
    }

    private DBObject createQuery(@Nullable Predicate predicate) {
        if (predicate != null) {
            return (DBObject)this.serializer.handle((Expression<?>)predicate);
        }
        return new BasicDBObject();
    }

    public String toString() {
        return this.createQuery(this.queryMixin.getMetadata().getWhere()).toString();
    }

    private static class NoResults
    extends RuntimeException {
        private NoResults() {
        }
    }
}

