/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql.codegen;

import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.query.codegen.QueryTypeFactory;
import javax.inject.Inject;
import javax.inject.Named;

public final class SQLQueryTypeFactory
implements QueryTypeFactory {
    private final String packageName;
    private final String beanPackageName;
    private final int stripStart;
    private final int stripEnd;
    private final String prefix;
    private final String suffix;
    private final boolean replacePackage;

    @Inject
    public SQLQueryTypeFactory(@Named(value="packageName") String packageName, @Named(value="beanPackageName") String beanPackageName, @Named(value="beanPrefix") String beanPrefix, @Named(value="beanSuffix") String beanSuffix, @Named(value="prefix") String prefix, @Named(value="suffix") String suffix) {
        this.packageName = packageName;
        this.beanPackageName = beanPackageName;
        this.replacePackage = !packageName.equals(beanPackageName);
        this.stripStart = beanPrefix.length();
        this.stripEnd = beanSuffix.length();
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public Type create(Type type) {
        String packageName = type.getPackageName();
        if (this.replacePackage) {
            packageName = this.packageName + packageName.substring(this.beanPackageName.length());
        }
        String simpleName = type.getSimpleName();
        simpleName = this.prefix + simpleName.substring(this.stripStart, simpleName.length() - this.stripEnd) + this.suffix;
        return new SimpleType(packageName + "." + simpleName, packageName, simpleName, new Type[0]);
    }
}

