/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.types.Ops;

public class PostgresTemplates
extends SQLTemplates {
    public PostgresTemplates() {
        this('\\', false);
    }

    public PostgresTemplates(boolean quote) {
        this('\\', quote);
    }

    public PostgresTemplates(char escape, boolean quote) {
        super("\"", escape, quote);
        this.setDummyTable(null);
        this.addClass2TypeMappings("numeric(3,0)", Byte.class);
        this.addClass2TypeMappings("double precision", Double.class);
        this.add(Ops.MATCHES, "{0} ~ {1}");
        this.add(Ops.INDEX_OF, "strpos({0},{1})-1");
        this.add(Ops.INDEX_OF_2ARGS, "strpos({0},{1})-1");
        this.add(Ops.StringOps.LOCATE, "strpos({1},{0})");
        this.add(Ops.StringOps.LOCATE2, "strpos(repeat('^',{2s}-1) || substr({1},{2s}),{0})");
        if (escape == '\\') {
            this.add(Ops.LIKE, "{0} like {1}");
            this.add(Ops.ENDS_WITH, "{0} like {%1}");
            this.add(Ops.ENDS_WITH_IC, "{0l} like {%%1}");
            this.add(Ops.STARTS_WITH, "{0} like {1%}");
            this.add(Ops.STARTS_WITH_IC, "{0l} like {1%%}");
            this.add(Ops.STRING_CONTAINS, "{0} like {%1%}");
            this.add(Ops.STRING_CONTAINS_IC, "{0l} like {%%1%%}");
        }
        this.add(Ops.MathOps.RANDOM, "random()");
        this.add(Ops.MathOps.LN, "ln({0})");
        this.add(Ops.MathOps.LOG, "log({1},{0})");
        this.add(Ops.MathOps.COSH, "(exp({0}) + exp({0} * -1)) / 2");
        this.add(Ops.MathOps.COTH, "(exp({0} * 2) + 1) / (exp({0} * 2) - 1)");
        this.add(Ops.MathOps.SINH, "(exp({0}) - exp({0} * -1)) / 2");
        this.add(Ops.MathOps.TANH, "(exp({0} * 2) - 1) / (exp({0} * 2) + 1)");
        this.add(Ops.DateTimeOps.YEAR, "extract(year from {0})");
        this.add(Ops.DateTimeOps.YEAR_MONTH, "extract(year from {0}) * 100 + extract(month from {0})");
        this.add(Ops.DateTimeOps.MONTH, "extract(month from {0})");
        this.add(Ops.DateTimeOps.WEEK, "extract(week from {0})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "extract(day from {0})");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, "extract(dow from {0}) + 1");
        this.add(Ops.DateTimeOps.DAY_OF_YEAR, "extract(doy from {0})");
        this.add(Ops.DateTimeOps.HOUR, "extract(hour from {0})");
        this.add(Ops.DateTimeOps.MINUTE, "extract(minute from {0})");
        this.add(Ops.DateTimeOps.SECOND, "extract(second from {0})");
    }
}

