/*
 * Decompiled with CFR 0.152.
 */
package org.jawin.donated.win32;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.jawin.io.LittleEndianInputStream;
import org.jawin.util.HexFormatter;

public class EVENTLOGRECORD {
    public final int length;
    public final int recordNumber;
    final Date timeGenerated;
    final Date timeWritten;
    public final int eventID;
    public final short eventType;
    public final short eventCategory;
    final String[] strings;
    final byte[] bytes;
    public final String source;
    public final String computerName;

    public EVENTLOGRECORD(byte[] bytes) throws IOException {
        LittleEndianInputStream leis = new LittleEndianInputStream((InputStream)new ByteArrayInputStream(bytes));
        this.length = leis.readInt();
        leis.readInt();
        this.recordNumber = leis.readInt();
        this.timeGenerated = new Date(1000L * (long)leis.readInt());
        this.timeWritten = new Date(1000L * (long)leis.readInt());
        this.eventID = leis.readInt();
        this.eventType = leis.readShort();
        int numStrings = leis.readShort();
        this.eventCategory = leis.readShort();
        leis.readShort();
        leis.readInt();
        int stringOffset = leis.readInt();
        int userSidLength = leis.readInt();
        int userSidOffset = leis.readInt();
        int dataLength = leis.readInt();
        int dataOffset = leis.readInt();
        this.source = leis.readUnicodeSz(32);
        this.computerName = leis.readUnicodeSz(32);
        this.strings = new String[numStrings];
        if (numStrings != 0) {
            LittleEndianInputStream leisStrings = new LittleEndianInputStream((InputStream)new ByteArrayInputStream(bytes, stringOffset, bytes.length - stringOffset));
            for (int n = 0; n < numStrings; ++n) {
                this.strings[n] = leisStrings.readUnicodeSz(32);
            }
        }
        this.bytes = new byte[dataLength];
        if (dataLength != 0) {
            System.arraycopy(bytes, dataOffset, this.bytes, 0, dataLength);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("EVENTLOGRECORD source:" + this.source + " machine:" + this.computerName + "\n\tgenerated " + this.timeGenerated + "\n\twritten " + this.timeWritten);
        int length = this.strings.length;
        for (int n = 0; n < length; ++n) {
            sb.append("\n\t").append(this.strings[n]);
        }
        length = this.bytes.length;
        if (length > 0) {
            sb.append("\n\tRAW DATA:");
            sb.append(HexFormatter.convertBytesToString((byte[])this.bytes));
        }
        return sb.toString();
    }
}

