/*
 * Decompiled with CFR 0.152.
 */
package org.jawin.donated.win32;

import java.io.IOException;
import java.io.OutputStream;
import org.jawin.COMError;
import org.jawin.COMException;
import org.jawin.FuncPtr;
import org.jawin.ReturnFlags;
import org.jawin.donated.win32.EVENTLOGRECORD;
import org.jawin.io.LittleEndianOutputStream;
import org.jawin.io.NakedByteStream;
import org.jawin.marshal.StructConverter;

public class EventLog {
    private static final FuncPtr fpRES;
    private static final FuncPtr fpDES;
    private static final FuncPtr fpRE;
    private static final FuncPtr fpCEL;
    private static final FuncPtr fpOEL;
    private static final FuncPtr fpGOELR;
    private static final FuncPtr fpGNOELR;
    private static final FuncPtr fpREL;

    public static int RegisterEventSource(String serverName, String sourceName) throws COMException, IOException {
        return fpRES.invoke_I(serverName, sourceName, ReturnFlags.CHECK_FALSE);
    }

    public static int OpenEventLog(String serverName, String sourceName) throws COMException, IOException {
        return fpOEL.invoke_I(serverName, sourceName, ReturnFlags.CHECK_FALSE);
    }

    public static int DeregisterEventSource(int handle) throws COMException, IOException {
        return fpDES.invoke_I(handle, ReturnFlags.CHECK_FALSE);
    }

    public static int CloseEventLog(int handle) throws COMException, IOException {
        return fpCEL.invoke_I(handle, ReturnFlags.CHECK_FALSE);
    }

    public static int GetOldestEventLogRecord(int handle) throws COMException {
        return fpGOELR.invoke_OI(handle, ReturnFlags.CHECK_FALSE);
    }

    public static int GetNumberOfEventLogRecords(int handle) throws COMException {
        return fpGNOELR.invoke_OI(handle, ReturnFlags.CHECK_FALSE);
    }

    public static int ReportEvent(int log, int type, int category, int id, String event) throws COMException, IOException {
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(log);
        leos.writeInt(type);
        leos.writeInt(category);
        leos.writeInt(id);
        leos.writeInt(0);
        leos.writeInt(1);
        leos.writeInt(0);
        leos.writeInt(0);
        leos.writeInt(0);
        Object[] strings = new Object[]{new String[]{event}};
        byte[] res = fpRE.invoke("B28T4I:T1:", 36, nbs, strings, ReturnFlags.CHECK_FALSE);
        return StructConverter.bytesIntoInt((byte[])res, (int)0);
    }

    public static byte[] RawReadEventLog(int handle, int flags, int offset) throws IOException, COMException {
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(handle);
        leos.writeInt(flags);
        leos.writeInt(offset);
        byte[] sizeRes = fpREL.invoke("IIIAkAA:T8:L24n4", 28, nbs, null, ReturnFlags.CHECK_NONE);
        int size = StructConverter.bytesIntoInt((byte[])sizeRes, (int)0);
        leos.writeInt(size);
        byte[] res = fpREL.invoke("IIIM" + size + "IAA:T3:L12n" + size, 28, nbs, null, ReturnFlags.CHECK_FALSE);
        return res;
    }

    public static EVENTLOGRECORD ReadEventLog(int handle, int flags, int offset) throws IOException, COMException {
        byte[] rawRecord = EventLog.RawReadEventLog(handle, flags, offset);
        return new EVENTLOGRECORD(rawRecord);
    }

    static {
        try {
            fpRES = new FuncPtr("ADVAPI32.DLL", "RegisterEventSourceW");
            fpDES = new FuncPtr("ADVAPI32.DLL", "DeregisterEventSource");
            fpRE = new FuncPtr("ADVAPI32.DLL", "ReportEventW");
            fpOEL = new FuncPtr("ADVAPI32.DLL", "OpenEventLogW");
            fpCEL = new FuncPtr("ADVAPI32.DLL", "CloseEventLog");
            fpGOELR = new FuncPtr("ADVAPI32.DLL", "GetOldestEventLogRecord");
            fpGNOELR = new FuncPtr("ADVAPI32.DLL", "GetNumberOfEventLogRecords");
            fpREL = new FuncPtr("ADVAPI32.DLL", "ReadEventLogW");
        }
        catch (COMException ce) {
            throw new COMError("Unable to load event log entry points");
        }
    }
}

