/*
 * Decompiled with CFR 0.152.
 */
package org.jawin.donated.win32;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jawin.COMError;
import org.jawin.COMException;
import org.jawin.FuncPtr;
import org.jawin.ReturnFlags;
import org.jawin.io.LittleEndianInputStream;
import org.jawin.io.LittleEndianOutputStream;
import org.jawin.io.NakedByteStream;
import org.jawin.marshal.StructConverter;

public class Registry {
    private static final FuncPtr fpOK;
    private static final FuncPtr fpQV;
    private static final FuncPtr fpCK;
    private static final FuncPtr fpCrK;
    private static final FuncPtr fpDK;
    private static final FuncPtr fpEnum;
    private static final FuncPtr fpEnumV;

    public static int OpenKey(int key, String subkey) throws IOException, COMException {
        return fpOK.invoke_OI(key, subkey, ReturnFlags.CHECK_W32);
    }

    public static int CreateKey(int key, String subkey) throws IOException, COMException {
        return fpCrK.invoke_OI(key, subkey, ReturnFlags.CHECK_W32);
    }

    public static void DeleteKey(int key, String subkey) throws IOException, COMException {
        fpDK.invoke_I(key, subkey, ReturnFlags.CHECK_W32);
    }

    public static String QueryStringValue(int key, String subkey) throws IOException, COMException {
        byte[] raw = Registry.RawQueryValue(key, subkey);
        LittleEndianInputStream leis = new LittleEndianInputStream((InputStream)new ByteArrayInputStream(raw));
        return leis.readUnicodeSz(raw.length / 2);
    }

    public static byte[] RawQueryValue(int key, String subkey) throws IOException, COMException {
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(key);
        leos.writeStringUnicode(subkey);
        leos.writeInt(0);
        leos.writeInt(0);
        byte[] sizeRes = fpQV.invoke("IGIIkA:T7:L20n4", 24, nbs, null, ReturnFlags.CHECK_NONE);
        int size = StructConverter.bytesIntoInt((byte[])sizeRes, (int)0);
        leos.writeInt(size);
        byte[] res = fpQV.invoke("IGIIM" + size + "P4:T7:L16n" + size, 24, nbs, null, ReturnFlags.CHECK_W32);
        return res;
    }

    public static void CloseKey(int key) throws IOException, COMException {
        fpCK.invoke_I(key, ReturnFlags.CHECK_W32);
    }

    public static String RegEnumKey(int key, int index) throws Exception {
        byte[] result;
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        int size = 520;
        leos.writeInt(key);
        leos.writeInt(index);
        leos.writeInt(size);
        try {
            result = fpEnum.invoke("IIM" + size + "I:T7:L8n" + size, 16, nbs, null, ReturnFlags.CHECK_W32);
        }
        catch (COMException e) {
            if (e.hresult == -2147024637) {
                return null;
            }
            throw e;
        }
        LittleEndianInputStream leis = new LittleEndianInputStream((InputStream)new ByteArrayInputStream(result));
        return leis.readUnicodeSz(result.length / 2);
    }

    public static String RegEnumValue(int key, int index) throws Exception {
        byte[] result;
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        int size = 520;
        leos.writeInt(key);
        leos.writeInt(index);
        leos.writeInt(size);
        try {
            result = fpEnumV.invoke("IIA" + size + "I:T7:L8n" + size, 32, nbs, null, ReturnFlags.CHECK_W32);
        }
        catch (COMException e) {
            if (e.hresult == -2147024637) {
                return null;
            }
            throw e;
        }
        LittleEndianInputStream leis = new LittleEndianInputStream((InputStream)new ByteArrayInputStream(result));
        return leis.readUnicodeSz(result.length / 2);
    }

    static {
        try {
            fpOK = new FuncPtr("ADVAPI32.DLL", "RegOpenKeyW");
            fpQV = new FuncPtr("ADVAPI32.DLL", "RegQueryValueExW");
            fpCK = new FuncPtr("ADVAPI32.DLL", "RegCloseKey");
            fpCrK = new FuncPtr("ADVAPI32.DLL", "RegCreateKeyW");
            fpDK = new FuncPtr("ADVAPI32.DLL", "RegDeleteKeyW");
            fpEnum = new FuncPtr("ADVAPI32.DLL", "RegEnumKeyW");
            fpEnumV = new FuncPtr("ADVAPI32.DLL", "RegEnumValueW");
        }
        catch (COMException ce) {
            throw new COMError("Unable to load registry entry points");
        }
    }
}

