/*
 * Decompiled with CFR 0.152.
 */
package org.jawin.donated.win32;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jawin.COMException;
import org.jawin.FuncPtr;
import org.jawin.ReturnFlags;
import org.jawin.donated.win32.MSG;
import org.jawin.donated.win32.PAINTSTRUCT;
import org.jawin.donated.win32.RECT;
import org.jawin.donated.win32.WNDCLASS;
import org.jawin.io.LittleEndianInputStream;
import org.jawin.io.LittleEndianOutputStream;
import org.jawin.io.NakedByteStream;
import org.jawin.marshal.StructConverter;

public class User32 {
    static final String mstringRegisterClassW = "R" + WNDCLASS.token + ":I:";
    static final int msRegisterClassW = 4;
    static final int mstackCreateWindowExW = 48;
    static final String mstringBeginPaint = "IM64:T1:lN|64B64|";
    static final int msBeginPaint = 8;
    static final String mstringGetClientRect = "IR" + RECT.token + ":T1:ln" + "16";
    static final int msGetClientRect = 8;
    static final String mstringDrawTextW = "IGIR" + RECT.token + "I:T1:";
    static final int msDrawTextW = 20;
    static final String mstringEndPaint = "IR" + PAINTSTRUCT.token + "::";
    static final int msEndPaint = 8;

    public static void MessageBoxW(String msg, String title) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "MessageBoxW");
        fp.invoke_I(0, msg, title, 0, ReturnFlags.CHECK_FALSE);
    }

    public static int LoadIconW(int handle, int iconConstant) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "LoadIconW");
        return fp.invoke_I(handle, iconConstant, ReturnFlags.CHECK_FALSE);
    }

    public static int LoadCursorW(int hinst, int cursor) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "LoadCursorW");
        return fp.invoke_I(hinst, cursor, ReturnFlags.CHECK_FALSE);
    }

    public static short RegisterClassW(WNDCLASS cls) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "RegisterClassW");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        ArrayList alObjs = new ArrayList();
        cls.marshal(leos, alObjs);
        byte[] res = fp.invoke(mstringRegisterClassW, 4, nbs, alObjs.toArray(), ReturnFlags.CHECK_FALSE);
        return StructConverter.bytesIntoShort((byte[])res, (int)0);
    }

    public static int DefWindowProcW(int hwnd, int msg, int wParam, int lParam) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "DefWindowProcW");
        return fp.invoke_I(hwnd, msg, wParam, lParam, ReturnFlags.CHECK_NONE);
    }

    public static int CreateWindowExW(int dwExStyle, String lpClassName, String lpWindowName, int dwStyle, int X, int Y, int nWidth, int nHeight, int hWndParent, int hMenu, int hInstance, int lpParam) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "CreateWindowExW");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(dwExStyle);
        leos.writeStringUnicode(lpClassName);
        leos.writeStringUnicode(lpWindowName);
        leos.writeInt(dwStyle);
        leos.writeInt(X);
        leos.writeInt(Y);
        leos.writeInt(nWidth);
        leos.writeInt(nHeight);
        leos.writeInt(hWndParent);
        leos.writeInt(hMenu);
        leos.writeInt(hInstance);
        leos.writeInt(lpParam);
        byte[] res = fp.invoke("IGGIIIIIIIII:T1:", 48, nbs, null, ReturnFlags.CHECK_FALSE);
        return StructConverter.bytesIntoInt((byte[])res, (int)0);
    }

    public static boolean ShowWindow(int hwnd, int nCmdShow) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "ShowWindow");
        return 0 != fp.invoke_I(hwnd, nCmdShow, ReturnFlags.CHECK_NONE);
    }

    public static void UpdateWindow(int hWnd) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "UpdateWindow");
        fp.invoke_I(hWnd, ReturnFlags.CHECK_NONE);
    }

    public static boolean GetMessageW(MSG msg, int hWnd, int wMsgFilterMin, int wMsgFilterMax) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "GetMessageW");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(hWnd);
        leos.writeInt(wMsgFilterMin);
        leos.writeInt(wMsgFilterMax);
        byte[] res = fp.invoke("M28III:I:N|28B28|", 16, nbs, null, ReturnFlags.CHECK_NONE);
        ByteArrayInputStream bais = new ByteArrayInputStream(res);
        LittleEndianInputStream leis = new LittleEndianInputStream((InputStream)bais);
        boolean result = leis.readInt() != 0;
        msg.marshalOut(leis, null);
        return result;
    }

    public static boolean TranslateMessage(MSG msg) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "TranslateMessage");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leis = new LittleEndianOutputStream((OutputStream)nbs);
        msg.marshal(leis, null);
        return fp.invoke_I(nbs.getInternalBuffer(), ReturnFlags.CHECK_NONE) != 0;
    }

    public static boolean DispatchMessageW(MSG msg) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "DispatchMessageW");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leis = new LittleEndianOutputStream((OutputStream)nbs);
        msg.marshal(leis, null);
        return fp.invoke_I(nbs.getInternalBuffer(), ReturnFlags.CHECK_NONE) != 0;
    }

    public static void PostQuitMessage(int nExitCode) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "PostQuitMessage");
        fp.invoke_I(nExitCode, ReturnFlags.CHECK_NONE);
    }

    public static int BeginPaint(int hwnd, PAINTSTRUCT ps) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "BeginPaint");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(hwnd);
        leos.writeInt(0);
        byte[] res = fp.invoke(mstringBeginPaint, 8, nbs, null, ReturnFlags.CHECK_FALSE);
        ByteArrayInputStream bais = new ByteArrayInputStream(res);
        LittleEndianInputStream leis = new LittleEndianInputStream((InputStream)bais);
        int result = leis.readInt();
        ps.marshalOut(leis, null);
        return result;
    }

    public static void GetClientRect(int hwnd, RECT r) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "GetClientRect");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(hwnd);
        leos.writeInt(0);
        r.marshal(leos, null);
        byte[] res = fp.invoke(mstringGetClientRect, 8, nbs, null, ReturnFlags.CHECK_FALSE);
        ByteArrayInputStream bais = new ByteArrayInputStream(res);
        LittleEndianInputStream leis = new LittleEndianInputStream((InputStream)bais);
        leis.readInt();
        r.marshalOut(leis, null);
    }

    public static int DrawTextW(int hwnd, String lpString, int nCount, RECT lpRect, int nFormat) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "DrawTextW");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(hwnd);
        leos.writeStringUnicode(lpString);
        leos.writeInt(nCount);
        lpRect.marshal(leos, null);
        leos.writeInt(nFormat);
        byte[] res = fp.invoke(mstringDrawTextW, 20, nbs, null, ReturnFlags.CHECK_FALSE);
        return StructConverter.bytesIntoInt((byte[])res, (int)0);
    }

    public static void EndPaint(int hwnd, PAINTSTRUCT ps) throws COMException, IOException {
        FuncPtr fp = new FuncPtr("USER32.DLL", "EndPaint");
        NakedByteStream nbs = new NakedByteStream();
        LittleEndianOutputStream leos = new LittleEndianOutputStream((OutputStream)nbs);
        leos.writeInt(hwnd);
        ps.marshal(leos, null);
        fp.invoke(mstringEndPaint, 8, nbs, null, ReturnFlags.CHECK_NONE);
    }
}

