/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.http;

import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProcessRequestBody
extends RequestBody {
    private RequestBody delegate;
    private Listener listener;

    public ProcessRequestBody(RequestBody delegate, Listener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public MediaType contentType() {
        return this.delegate.contentType();
    }

    public long contentLength() throws IOException {
        return this.delegate.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        ProgressSink progressSink = new ProgressSink((Sink)sink);
        BufferedSink bufferedSink = Okio.buffer((Sink)progressSink);
        this.delegate.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    public static interface Listener {
        public void onRequestProgress(long var1, long var3);
    }

    private final class ProgressSink
    extends ForwardingSink {
        private long bytesWritten;

        ProgressSink(Sink delegate) {
            super(delegate);
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            this.bytesWritten += byteCount;
            ProcessRequestBody.this.listener.onRequestProgress(this.bytesWritten, ProcessRequestBody.this.contentLength());
        }
    }
}

