/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.response.handle;

import com.mzlion.core.json.TypeRef;
import com.mzlion.core.json.gson.JsonUtil;
import com.mzlion.core.lang.StringUtils;
import com.mzlion.easyokhttp.response.handle.DataHandler;
import com.mzlion.easyokhttp.response.handle.StringDataHandler;
import java.io.IOException;
import okhttp3.Response;

public class JsonDataHandler<T>
implements DataHandler<T> {
    private Class<T> delegateClass;
    private TypeRef<T> typeRef;

    public JsonDataHandler() {
    }

    public JsonDataHandler(Class<T> delegateClass) {
        this.delegateClass = delegateClass;
    }

    public JsonDataHandler(TypeRef<T> typeRef) {
        this.typeRef = typeRef;
    }

    public JsonDataHandler(Class<T> delegateClass, TypeRef<T> typeRef) {
        this.delegateClass = delegateClass;
        this.typeRef = typeRef;
    }

    public Class<T> getDelegateClass() {
        return this.delegateClass;
    }

    public void setDelegateClass(Class<T> delegateClass) {
        this.delegateClass = delegateClass;
    }

    public TypeRef<T> getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(TypeRef<T> typeRef) {
        this.typeRef = typeRef;
    }

    @Override
    public T handle(Response response) throws IOException {
        StringDataHandler stringDataHandler = StringDataHandler.create();
        String valueContent = stringDataHandler.handle(response);
        if (StringUtils.hasLength((String)valueContent)) {
            if (null != this.delegateClass) {
                return (T)JsonUtil.fromJson((String)valueContent, this.delegateClass);
            }
            if (null != this.typeRef) {
                return (T)JsonUtil.fromJson((String)valueContent, this.typeRef);
            }
            return null;
        }
        return null;
    }
}

