/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.utils;

import com.mzlion.core.io.IOUtils;
import com.mzlion.core.lang.ArrayUtils;
import java.io.Closeable;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLContexts {
    private static X509TrustManager unSafeTrustManager = new X509TrustManager(){

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    };

    public static SSLConfig tryParse(InputStream[] certificates, X509TrustManager x509TrustManager, InputStream pfxCertificate, char[] pfxPassword) {
        try {
            X509TrustManager trustManager;
            SSLConfig sslConfig = new SSLConfig();
            KeyManager[] keyManagers = SSLContexts.prepareKeyManagers(pfxCertificate, pfxPassword);
            if (x509TrustManager != null) {
                trustManager = x509TrustManager;
            } else {
                trustManager = SSLContexts.prepareX509TrustManager(certificates);
                if (trustManager == null) {
                    trustManager = unSafeTrustManager;
                }
            }
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, new SecureRandom());
            sslConfig.setSslSocketFactory(sslContext.getSocketFactory());
            sslConfig.setX509TrustManager(trustManager);
            return sslConfig;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    private static X509TrustManager prepareX509TrustManager(InputStream ... certificates) throws Exception {
        if (ArrayUtils.isEmpty((Object[])certificates)) {
            return null;
        }
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null);
        int length = certificates.length;
        for (int i = 0; i < length; ++i) {
            keyStore.setCertificateEntry(String.valueOf(i + 1), factory.generateCertificate(certificates[i]));
            IOUtils.closeQuietly((Closeable)certificates[i]);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + ArrayUtils.toString((Object[])trustManagers));
        }
        return (X509TrustManager)trustManagers[0];
    }

    private static KeyManager[] prepareKeyManagers(InputStream pfxCertificate, char[] pfxPassword) throws Exception {
        if (pfxCertificate == null || ArrayUtils.isEmpty((char[])pfxPassword)) {
            return null;
        }
        KeyStore clientKS = KeyStore.getInstance("PKCS12");
        clientKS.load(pfxCertificate, pfxPassword);
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        factory.init(clientKS, pfxPassword);
        return factory.getKeyManagers();
    }

    public static final class SSLConfig {
        private SSLSocketFactory sslSocketFactory;
        private X509TrustManager x509TrustManager;

        public SSLSocketFactory getSslSocketFactory() {
            return this.sslSocketFactory;
        }

        void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
        }

        public X509TrustManager getX509TrustManager() {
            return this.x509TrustManager;
        }

        void setX509TrustManager(X509TrustManager x509TrustManager) {
            this.x509TrustManager = x509TrustManager;
        }
    }
}

