/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.easyokhttp.utils;

import com.mzlion.core.digest.MD5;
import com.mzlion.core.lang.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.FileNameMap;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Locale;
import okhttp3.MediaType;
import okhttp3.Response;

public class Utils {
    private static String acceptLanguage;
    private static String userAgent;

    public static void setAcceptLanguage(String acceptLanguage) {
        Utils.acceptLanguage = acceptLanguage;
    }

    public static String getAcceptLanguage() {
        if (StringUtils.isEmpty((String)acceptLanguage)) {
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            StringBuffer sb = new StringBuffer(language);
            if (StringUtils.hasLength((String)country)) {
                sb.append('-').append(country).append(',').append(language).append(";q=0.8");
            }
            acceptLanguage = sb.toString();
        }
        return acceptLanguage;
    }

    public static String getUserAgent() {
        if (StringUtils.isEmpty((String)userAgent)) {
            userAgent = "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/55.0.2883.75 Safari/537.36";
        }
        return userAgent;
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return value;
        }
    }

    public static MediaType guessMediaType(String filename) {
        String pathname;
        if (filename == null) {
            return MediaType.parse((String)"application/octet-stream");
        }
        FileNameMap fileNameMap = URLConnection.getFileNameMap();
        String contentType = fileNameMap.getContentTypeFor(pathname = filename.replace("#", ""));
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return MediaType.parse((String)contentType);
    }

    public static String getFilename(Response response) {
        String urlSnippet;
        String filename;
        String split;
        int index;
        String headerValue = response.header("Content-Disposition");
        if (headerValue != null && (index = headerValue.indexOf(split = "filename=")) != -1) {
            String pathname = headerValue.substring(index + split.length());
            if ((index = pathname.lastIndexOf("/")) != -1) {
                return pathname.substring(index + 1);
            }
            return pathname;
        }
        String url = response.request().url().toString();
        index = url.indexOf("?");
        if (index > 0 && (filename = (urlSnippet = url.substring(0, index)).substring(url.lastIndexOf("/") + 1)).contains(".")) {
            return filename;
        }
        return MD5.digestHex((String)url);
    }
}

