/*
 * Decompiled with CFR 0.152.
 */
package com.mzlion.core.io.resource;

import com.mzlion.core.io.IOUtils;
import com.mzlion.core.io.ResourceUtils;
import com.mzlion.core.io.resource.ResourceDescriptor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public abstract class AbstractResourceDescriptor
implements ResourceDescriptor {
    @Override
    public boolean exists() {
        File file;
        try {
            file = this.getFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        if (file == null) {
            try {
                InputStream in = this.getInputStream();
                in.close();
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return file.exists();
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException(this.getDescription() + " cannot be resolved to URL");
    }

    @Override
    public URI getURI() throws IOException {
        URL url = this.getURL();
        try {
            return ResourceUtils.toURI(url);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid URI [" + url + "]", e);
        }
    }

    @Override
    public File getFile() throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long length() {
        InputStream in = this.getInputStream();
        if (in == null) {
            return -1L;
        }
        long size = 0L;
        byte[] buffer = new byte[1024];
        try {
            int read;
            while ((read = in.read(buffer)) != -1) {
                size += (long)read;
            }
            long l = size;
            return l;
        }
        catch (IOException e) {
            long l = -1L;
            return l;
        }
        finally {
            IOUtils.closeQuietly(in);
        }
    }

    @Override
    public String getFilename() {
        return null;
    }

    public String toString() {
        return this.getDescription();
    }
}

