/*
 * Decompiled with CFR 0.152.
 */
package com.nhncorp.lucy.security.xss.listener;

import com.nhncorp.lucy.security.xss.listener.ContentType;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ContentTypeCacheRepo {
    private static final int HARD_CACHE_CAPACITY = 1000;
    private final HashMap<String, ContentType> sHardBitmapCache = new LinkedHashMap<String, ContentType>(1334, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, ContentType> eldest) {
            if (this.size() > 1000) {
                sSoftBitmapCache.put(eldest.getKey(), new WeakReference<ContentType>(eldest.getValue()));
                return true;
            }
            return false;
        }
    };
    private static final ConcurrentHashMap<String, WeakReference<ContentType>> sSoftBitmapCache = new ConcurrentHashMap(500);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentType getContentTypeCacheFromCache(String url) {
        ContentType contentTypeCache;
        HashMap<String, ContentType> hashMap = this.sHardBitmapCache;
        synchronized (hashMap) {
            contentTypeCache = this.sHardBitmapCache.get(url);
            if (contentTypeCache != null) {
                return contentTypeCache;
            }
        }
        WeakReference<ContentType> contentTypeCacheReference = sSoftBitmapCache.get(url);
        if (contentTypeCacheReference != null) {
            contentTypeCache = (ContentType)contentTypeCacheReference.get();
            if (contentTypeCache != null) {
                return contentTypeCache;
            }
            sSoftBitmapCache.remove(url);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentTypeFromCache(String url) {
        ContentType contentTypeCache = this.getContentTypeCacheFromCache(url);
        if (contentTypeCache == null) {
            return "";
        }
        Date regdate = contentTypeCache.getRegdate();
        Date today = new Date();
        String contentType = "";
        if (today.getTime() - regdate.getTime() < 86400000L) {
            contentType = contentTypeCache.getContentType();
        } else {
            HashMap<String, ContentType> hashMap = this.sHardBitmapCache;
            synchronized (hashMap) {
                this.sHardBitmapCache.remove(url);
            }
        }
        return contentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContentTypeToCache(String url, ContentType contentTypeCache) {
        if (contentTypeCache != null) {
            HashMap<String, ContentType> hashMap = this.sHardBitmapCache;
            synchronized (hashMap) {
                this.sHardBitmapCache.put(url, contentTypeCache);
            }
        }
    }

    public void clearCache() {
        this.sHardBitmapCache.clear();
        sSoftBitmapCache.clear();
    }
}

